/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.event.ApiEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiManager {
    private final Logger logger = LoggerFactory.getLogger(ApiManager.class);
    private final Map<String, GenericApiEntity> apis = new HashMap<String, GenericApiEntity>();
    @Autowired
    private EventManager eventManager;

    public void deploy(GenericApiEntity api) {
        this.logger.info("Deployment of {}", (Object)api);
        this.apis.put(api.getId(), api);
        if (api.getState() == Lifecycle.State.STARTED) {
            this.eventManager.publishEvent((Enum)ApiEvent.DEPLOY, (Object)api);
        } else {
            this.logger.debug("{} is not enabled. Skip deployment.", (Object)api);
        }
    }

    public void update(GenericApiEntity api) {
        this.apis.put(api.getId(), api);
        this.eventManager.publishEvent((Enum)ApiEvent.UPDATE, (Object)api);
    }

    public void undeploy(String apiId) {
        GenericApiEntity currentApi = this.apis.remove(apiId);
        if (currentApi != null) {
            this.logger.info("Undeployment of {}", (Object)currentApi);
            this.eventManager.publishEvent((Enum)ApiEvent.UNDEPLOY, (Object)currentApi);
            this.logger.info("{} has been undeployed", (Object)apiId);
        }
    }

    public Collection<GenericApiEntity> apis() {
        return this.apis.values();
    }

    public GenericApiEntity get(String name) {
        return this.apis.get(name);
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

