/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties.provider.http;

import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.utils.NodeUtils;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.services.dynamicproperties.model.DynamicProperty;
import io.gravitee.rest.api.services.dynamicproperties.provider.Provider;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.mapper.JoltMapper;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.rxjava3.core.http.HttpClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpProvider
implements Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProvider.class);
    private static final String HTTPS_SCHEME = "https";
    private final HttpDynamicPropertyProviderConfiguration dpConfiguration;
    private JoltMapper mapper;
    private HttpClientService httpClientService;
    private Node node;
    private Executor executor;

    public HttpProvider(DynamicPropertyService dpService) {
        Objects.requireNonNull(dpService, "Service must not be null");
        this.dpConfiguration = (HttpDynamicPropertyProviderConfiguration)dpService.getConfiguration();
        this.mapper = new JoltMapper(this.dpConfiguration.getSpecification());
    }

    @Override
    public Maybe<Collection<DynamicProperty>> get() {
        URL requestUrl = null;
        try {
            requestUrl = new URL(this.dpConfiguration.getUrl());
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Unable to parse URL: {}", (Object)this.dpConfiguration.getUrl(), (Object)ex);
            return Maybe.empty();
        }
        HttpClient httpClient = new HttpClient(this.httpClientService.createHttpClient(requestUrl.getProtocol(), Boolean.valueOf(this.dpConfiguration.isUseSystemProxy())));
        int port = requestUrl.getPort() != -1 ? requestUrl.getPort() : (HTTPS_SCHEME.equals(requestUrl.getProtocol()) ? 443 : 80);
        String relativeUri = requestUrl.getQuery() == null ? requestUrl.getPath() : requestUrl.getPath() + "?" + requestUrl.getQuery();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.valueOf((String)this.dpConfiguration.getMethod().name())).setHost(requestUrl.getHost()).setPort(Integer.valueOf(port)).setURI(relativeUri);
        options.putHeader("User-Agent", NodeUtils.userAgent((Node)this.node));
        options.putHeader("X-Gravitee-Request-Id", UuidString.generateRandom());
        if (this.dpConfiguration.getHeaders() != null) {
            this.dpConfiguration.getHeaders().forEach(httpHeader -> options.putHeader(httpHeader.getName(), httpHeader.getValue()));
        }
        return httpClient.rxRequest(options).flatMap(request -> {
            LOGGER.debug("Dynamic properties will be fetched with the following request: {} {}", (Object)request.getMethod(), (Object)request.absoluteURI());
            if (StringUtils.hasText((String)this.dpConfiguration.getBody())) {
                return request.rxSend(this.dpConfiguration.getBody());
            }
            return request.rxSend();
        }).filter(response -> response.statusCode() == 200).flatMap(response -> response.rxBody().toMaybe()).doFinally(() -> ((HttpClient)httpClient).close()).observeOn(Schedulers.from((Executor)this.executor)).map(buffer -> this.mapper.map(buffer.toString()));
    }

    @Override
    public String name() {
        return "http-provider";
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

