/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary;

import io.gravitee.definition.model.Property;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryNotFoundException;
import io.gravitee.rest.api.services.dictionary.model.DynamicProperty;
import io.gravitee.rest.api.services.dictionary.provider.Provider;
import io.vertx.core.Handler;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryRefresher
implements Handler<Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryRefresher.class);
    private DictionaryEntity dictionary;
    private Provider provider;
    private DictionaryService dictionaryService;

    public DictionaryRefresher(DictionaryEntity dictionary) {
        this.dictionary = dictionary;
    }

    public void handle(Long event) {
        log.debug("Running dictionary refresher task for {}", (Object)this.dictionary);
        this.provider.get().whenComplete((dynamicProperties, throwable) -> {
            if (throwable != null) {
                log.error("[{}] Unexpected error while getting dictionary's properties from provider: {}", new Object[]{this.dictionary.getId(), this.provider.name(), throwable});
            } else if (dynamicProperties != null) {
                this.updateDictionary((Collection<DynamicProperty>)dynamicProperties);
            }
        });
    }

    private void updateDictionary(Collection<DynamicProperty> dynProperties) {
        Map<String, String> properties = dynProperties.stream().collect(Collectors.toMap(Property::getKey, dynamicProperty -> dynamicProperty.getValue() == null ? "" : dynamicProperty.getValue(), (oldValue, newValue) -> {
            log.error("Duplicate key found (attempted merging values {} and {}) for dictionary {}", new Object[]{oldValue, newValue, this.dictionary.getName()});
            throw new IllegalStateException(String.format("Duplicate key found (attempted merging values {} and {}) for dictionary {}", oldValue, newValue, this.dictionary.getName()));
        }));
        if (!properties.equals(this.dictionary.getProperties())) {
            try {
                this.dictionary = this.dictionaryService.updateProperties(GraviteeContext.getExecutionContext(), this.dictionary.getId(), properties);
            }
            catch (DictionaryNotFoundException e) {
                log.debug("Trying to update a deleted dictionary {} - nothing to do...", (Object)this.dictionary.getId());
            }
            catch (Exception ex) {
                log.error("Unexpected error while updating and deploying the dictionary {}", (Object)this.dictionary.getId(), (Object)ex);
            }
        }
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

