/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary.provider.http;

import io.gravitee.node.api.Node;
import io.gravitee.node.api.utils.NodeUtils;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.services.dictionary.model.DynamicProperty;
import io.gravitee.rest.api.services.dictionary.provider.Provider;
import io.gravitee.rest.api.services.dictionary.provider.http.configuration.HttpProviderConfiguration;
import io.gravitee.rest.api.services.dictionary.provider.http.mapper.JoltMapper;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProvider
implements Provider {
    private final Logger logger = LoggerFactory.getLogger(HttpProvider.class);
    private static final String HTTPS_SCHEME = "https";
    private final HttpProviderConfiguration configuration;
    private JoltMapper mapper;
    private HttpClientService httpClientService;
    private Node node;

    public HttpProvider(HttpProviderConfiguration configuration) {
        Objects.requireNonNull(configuration, "Configuration must not be null");
        this.configuration = configuration;
        this.mapper = new JoltMapper(configuration.getSpecification());
    }

    @Override
    public CompletableFuture<Collection<DynamicProperty>> get() {
        CompletableFuture future = new CompletableFuture();
        URI requestUri = URI.create(this.configuration.getUrl());
        HttpClient httpClient = this.httpClientService.createHttpClient(requestUri.getScheme(), Boolean.valueOf(this.configuration.isUseSystemProxy()));
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        try {
            String relativeUri = requestUri.getRawQuery() == null ? requestUri.getRawPath() : requestUri.getRawPath() + "?" + requestUri.getRawQuery();
            HttpClientRequest request = httpClient.request(HttpMethod.GET, port, requestUri.getHost(), relativeUri);
            request.putHeader("User-Agent", NodeUtils.userAgent((Node)this.node));
            request.putHeader("X-Gravitee-Request-Id", RandomString.generate());
            if (this.configuration.getHeaders() != null) {
                this.configuration.getHeaders().forEach(httpHeader -> request.putHeader(httpHeader.getName(), httpHeader.getValue()));
            }
            request.handler(response -> {
                if (response.statusCode() == 200) {
                    response.bodyHandler(buffer -> {
                        future.complete(buffer);
                        httpClient.close();
                    });
                } else {
                    future.complete(null);
                    httpClient.close();
                }
            });
            request.exceptionHandler(event -> {
                try {
                    future.completeExceptionally((Throwable)event);
                    httpClient.close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
            request.end();
        }
        catch (Exception ex) {
            this.logger.error("Unable to look for dynamic properties", (Throwable)ex);
            future.completeExceptionally(ex);
            httpClient.close();
        }
        return future.thenApply(buffer -> {
            if (buffer == null) {
                return null;
            }
            return this.mapper.map(buffer.toString());
        });
    }

    @Override
    public String name() {
        return "custom";
    }

    public void setMapper(JoltMapper mapper) {
        this.mapper = mapper;
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void setNode(Node node) {
        this.node = node;
    }
}

