/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary;

import io.gravitee.definition.model.Property;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.UpdateDictionaryEntity;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryNotFoundException;
import io.gravitee.rest.api.services.dictionary.model.DynamicProperty;
import io.gravitee.rest.api.services.dictionary.provider.Provider;
import io.vertx.core.Handler;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryRefresher
implements Handler<Long> {
    private final Logger logger = LoggerFactory.getLogger(DictionaryRefresher.class);
    private DictionaryEntity dictionary;
    private Provider provider;
    private DictionaryService dictionaryService;

    public DictionaryRefresher(DictionaryEntity dictionary) {
        this.dictionary = dictionary;
    }

    public void handle(Long event) {
        this.logger.debug("Running dictionary refresher task for {}", (Object)this.dictionary);
        this.provider.get().whenComplete((dynamicProperties, throwable) -> {
            if (throwable != null) {
                this.logger.error("[{}] Unexpected error while getting dictionary's properties from provider: {}", new Object[]{this.dictionary.getId(), this.provider.name(), throwable});
            } else if (dynamicProperties != null) {
                this.updateDictionary((Collection<DynamicProperty>)dynamicProperties);
            }
        });
    }

    private void updateDictionary(Collection<DynamicProperty> dynProperties) {
        Map<String, String> properties = dynProperties.stream().collect(Collectors.toMap(Property::getKey, dynamicProperty -> dynamicProperty.getValue() == null ? "" : dynamicProperty.getValue()));
        if (!properties.equals(this.dictionary.getProperties())) {
            try {
                this.dictionary = this.dictionaryService.findById(this.dictionary.getId());
                this.dictionary.setProperties(properties);
                this.dictionary = this.dictionaryService.update(GraviteeContext.getExecutionContext(), this.dictionary.getId(), this.convert(this.dictionary));
                this.dictionaryService.deploy(GraviteeContext.getExecutionContext(), this.dictionary.getId());
            }
            catch (DictionaryNotFoundException e) {
                this.logger.info("Trying to update a deleted dictionary - nothing to do...");
            }
            catch (Exception ex) {
                this.logger.error("Unexpected error while updating and deploying the dictionary", (Throwable)ex);
            }
        }
    }

    private UpdateDictionaryEntity convert(DictionaryEntity dictionaryEntity) {
        UpdateDictionaryEntity dictionary = new UpdateDictionaryEntity();
        dictionary.setName(dictionaryEntity.getName());
        dictionary.setDescription(dictionaryEntity.getDescription());
        dictionary.setType(dictionaryEntity.getType());
        dictionary.setProperties(dictionaryEntity.getProperties());
        dictionary.setProvider(dictionaryEntity.getProvider());
        dictionary.setTrigger(dictionaryEntity.getTrigger());
        return dictionary;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }
}

