/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.v2.security.config;

import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.management.v2.security.config.GraviteeCorsConfiguration;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public class GraviteeUrlBasedCorsConfigurationSource
extends UrlBasedCorsConfigurationSource {
    private final Map<String, GraviteeCorsConfiguration> corsConfigurationByOrganization = new HashMap<String, GraviteeCorsConfiguration>();
    private final ParameterService parameterService;
    private final EventManager eventManager;

    public GraviteeUrlBasedCorsConfigurationSource(ParameterService parameterService, EventManager eventManager) {
        this.parameterService = parameterService;
        this.eventManager = eventManager;
    }

    private String computeOrganizationId(HttpServletRequest request) {
        return GraviteeContext.getDefaultOrganization();
    }

    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        String organizationId = this.computeOrganizationId(request);
        if (organizationId != null) {
            GraviteeCorsConfiguration corsConfiguration = this.corsConfigurationByOrganization.get(organizationId);
            if (corsConfiguration == null) {
                corsConfiguration = new GraviteeCorsConfiguration(this.parameterService, this.eventManager, organizationId);
                this.corsConfigurationByOrganization.put(organizationId, corsConfiguration);
            }
            return corsConfiguration;
        }
        return super.getCorsConfiguration(request);
    }
}

