/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.v2.security.config;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.cors.CorsConfiguration;

public class GraviteeCorsConfiguration
extends CorsConfiguration
implements EventListener<Key, Parameter> {
    private ParameterService parameterService;
    private String organizationId;

    public GraviteeCorsConfiguration(ParameterService parameterService, EventManager eventManager, String organizationId) {
        this.parameterService = parameterService;
        this.organizationId = organizationId;
        eventManager.subscribeForEvents((EventListener)this, Key.class);
        this.setAllowCredentials(true);
        this.setAllowedOriginPatterns(this.getPropertiesAsList(Key.CONSOLE_HTTP_CORS_ALLOW_ORIGIN, "*"));
        this.setAllowedHeaders(this.getPropertiesAsList(Key.CONSOLE_HTTP_CORS_ALLOW_HEADERS, "Cache-Control, Pragma, Origin, Authorization, Content-Type, X-Requested-With, If-Match, X-Xsrf-Token, X-Recaptcha-Token"));
        this.setAllowedMethods(this.getPropertiesAsList(Key.CONSOLE_HTTP_CORS_ALLOW_METHODS, "OPTIONS, GET, POST, PUT, DELETE, PATCH"));
        this.setExposedHeaders(this.getPropertiesAsList(Key.CONSOLE_HTTP_CORS_EXPOSED_HEADERS, "ETag, X-Xsrf-Token"));
        this.setMaxAge(Long.valueOf(parameterService.find(GraviteeContext.getExecutionContext(), Key.CONSOLE_HTTP_CORS_MAX_AGE, organizationId, ParameterReferenceType.ORGANIZATION)));
    }

    public void onEvent(Event<Key, Parameter> event) {
        if (this.organizationId.equals(((Parameter)event.content()).getReferenceId())) {
            switch ((Key)event.type()) {
                case CONSOLE_HTTP_CORS_ALLOW_ORIGIN: {
                    this.setAllowedOriginPatterns(this.semicolonStringToList(((Parameter)event.content()).getValue()));
                    break;
                }
                case CONSOLE_HTTP_CORS_ALLOW_HEADERS: {
                    this.setAllowedHeaders(this.semicolonStringToList(((Parameter)event.content()).getValue()));
                    break;
                }
                case CONSOLE_HTTP_CORS_ALLOW_METHODS: {
                    this.setAllowedMethods(this.semicolonStringToList(((Parameter)event.content()).getValue()));
                    break;
                }
                case CONSOLE_HTTP_CORS_EXPOSED_HEADERS: {
                    this.setExposedHeaders(this.semicolonStringToList(((Parameter)event.content()).getValue()));
                    break;
                }
                case CONSOLE_HTTP_CORS_MAX_AGE: {
                    this.setMaxAge(Long.parseLong(((Parameter)event.content()).getValue()));
                }
            }
        }
    }

    private List<String> getPropertiesAsList(Key propertyKey, String defaultValue) {
        String property = this.parameterService.find(GraviteeContext.getExecutionContext(), propertyKey, this.organizationId, ParameterReferenceType.ORGANIZATION);
        if (property == null) {
            property = defaultValue;
        }
        return this.semicolonStringToList(property);
    }

    private List<String> semicolonStringToList(String listStr) {
        return Arrays.asList(listStr.replaceAll("\\s+", "").split(";"));
    }
}

