/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.idp.api.IdentityProvider;
import io.gravitee.rest.api.idp.api.authentication.AuthenticationProvider;
import io.gravitee.rest.api.idp.core.plugin.IdentityProviderManager;
import io.gravitee.rest.api.management.security.config.GraviteeUrlBasedCorsConfigurationSource;
import io.gravitee.rest.api.security.authentication.AuthenticationProviderManager;
import io.gravitee.rest.api.security.authentication.GraviteeAuthenticationDetails;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.csrf.CookieCsrfSignedTokenRepository;
import io.gravitee.rest.api.security.csrf.CsrfRequestMatcher;
import io.gravitee.rest.api.security.filter.CsrfIncludeFilter;
import io.gravitee.rest.api.security.filter.RecaptchaFilter;
import io.gravitee.rest.api.security.filter.TokenAuthenticationFilter;
import io.gravitee.rest.api.security.listener.AuthenticationFailureListener;
import io.gravitee.rest.api.security.listener.AuthenticationSuccessListener;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.ReCaptchaService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
@Profile(value={"basic"})
@EnableWebSecurity
public class BasicSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSecurityConfigurerAdapter.class);
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private IdentityProviderManager identityProviderManager;
    @Autowired
    private AuthenticationProviderManager authenticationProviderManager;
    @Autowired
    private CookieGenerator cookieGenerator;
    @Autowired
    private ReCaptchaService reCaptchaService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private EventManager eventManager;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOGGER.info("--------------------------------------------------------------");
        LOGGER.info("Management API BasicSecurity Config");
        LOGGER.info("Loading authentication identity providers for Basic authentication");
        List providers = this.authenticationProviderManager.getIdentityProviders().stream().filter(authenticationProvider -> !authenticationProvider.external()).collect(Collectors.toList());
        for (io.gravitee.rest.api.security.authentication.AuthenticationProvider provider : providers) {
            LOGGER.info("Loading authentication provider of type {} at position {}", (Object)provider.type(), (Object)provider.index());
            boolean found = false;
            Collection identityProviders = this.identityProviderManager.getAll();
            for (IdentityProvider identityProvider : identityProviders) {
                AuthenticationProvider authenticationProviderPlugin;
                if (!identityProvider.type().equalsIgnoreCase(provider.type()) || (authenticationProviderPlugin = this.identityProviderManager.loadIdentityProvider(identityProvider.type(), provider.configuration())) == null) continue;
                Object authenticationProvider2 = authenticationProviderPlugin.configure();
                if (authenticationProvider2 instanceof org.springframework.security.authentication.AuthenticationProvider) {
                    auth.authenticationProvider((org.springframework.security.authentication.AuthenticationProvider)authenticationProvider2);
                } else if (authenticationProvider2 instanceof SecurityConfigurer) {
                    auth.apply((SecurityConfigurer)authenticationProvider2);
                }
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.error("No authentication provider found for type: {}", (Object)provider.type());
        }
        LOGGER.info("--------------------------------------------------------------");
    }

    @Bean
    public AuthenticationSuccessListener authenticationSuccessListener() {
        return new AuthenticationSuccessListener();
    }

    @Bean
    public AuthenticationFailureListener authenticationFailureListener() {
        return new AuthenticationFailureListener();
    }

    @Bean
    public CookieCsrfSignedTokenRepository cookieCsrfSignedTokenRepository() {
        return new CookieCsrfSignedTokenRepository();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        return new GraviteeUrlBasedCorsConfigurationSource(this.parameterService, this.eventManager);
    }

    protected void configure(HttpSecurity http) throws Exception {
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        if ("myJWT4Gr4v1t33_S3cr3t".equals(jwtSecret)) {
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("#                      SECURITY WARNING                      #");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
            LOGGER.warn("You still use the default jwt secret.");
            LOGGER.warn("This known secret can be used to impersonate anyone.");
            LOGGER.warn("Please change this value, or ask your administrator to do it !");
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
        }
        this.authentication(http);
        this.session(http);
        this.authorizations(http);
        this.hsts(http);
        this.csrf(http);
        this.cors(http);
        http.addFilterBefore((Filter)new TokenAuthenticationFilter(jwtSecret, this.cookieGenerator, this.userService, this.tokenService, this.authoritiesProvider), BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)new RecaptchaFilter(this.reCaptchaService, this.objectMapper), TokenAuthenticationFilter.class);
    }

    private HttpSecurity authentication(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.httpBasic().authenticationDetailsSource(this.authenticationDetailsSource()).realmName("Gravitee.io Management API").and();
    }

    private HttpSecurity session(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }

    private HttpSecurity authorizations(HttpSecurity security) throws Exception {
        String uriOrgPrefix = "/organizations/**";
        String uriPrefix = uriOrgPrefix + "/environments/**";
        return (HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/swagger.json"})).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{"**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/auth/cockpit"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/console/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/auth/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/social-identities"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/user/login"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/user/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users/custom-fields"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/users/registration/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriOrgPrefix + "/users/**/changePassword"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.PUT, new String[]{uriOrgPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{uriOrgPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/configuration/rolescopes/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/configuration/custom-user-fields"})).permitAll().antMatchers(new String[]{uriOrgPrefix + "/configuration/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriOrgPrefix + "/search/users"})).authenticated().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/auth/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/user/login"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/user/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users/custom-fields"})).permitAll().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/users/registration/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/users/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/rolescopes/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/search/users"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/apis/hooks"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/apis/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/apis"})).authenticated().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/apis/**"})).authenticated().antMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/apis/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/apis/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/applications"})).authenticated().antMatchers(HttpMethod.POST, new String[]{uriPrefix + "/applications/**"})).authenticated().antMatchers(HttpMethod.PUT, new String[]{uriPrefix + "/applications/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{uriPrefix + "/applications/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/subscriptions/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/instances/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/platform/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/groups/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/categories/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/tags/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/configuration/tenants/**"})).permitAll().antMatchers(new String[]{uriPrefix + "/configuration/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{uriPrefix + "/entrypoints/**"})).permitAll().anyRequest()).authenticated().and();
    }

    private AuthenticationDetailsSource<HttpServletRequest, GraviteeAuthenticationDetails> authenticationDetailsSource() {
        return GraviteeAuthenticationDetails::new;
    }

    private HttpSecurity hsts(HttpSecurity security) throws Exception {
        HeadersConfigurer.HstsConfig hstsConfig = security.headers().httpStrictTransportSecurity();
        Boolean hstsEnabled = (Boolean)this.environment.getProperty("http.hsts.enabled", Boolean.class, (Object)true);
        if (hstsEnabled.booleanValue()) {
            return (HttpSecurity)hstsConfig.includeSubDomains(((Boolean)this.environment.getProperty("http.hsts.include-sub-domains", Boolean.class, (Object)true)).booleanValue()).maxAgeInSeconds(((Long)this.environment.getProperty("http.hsts.max-age", Long.class, (Object)31536000L)).longValue()).and().and();
        }
        return (HttpSecurity)hstsConfig.disable().and();
    }

    private HttpSecurity csrf(HttpSecurity security) throws Exception {
        if (((Boolean)this.environment.getProperty("http.csrf.enabled", Boolean.class, (Object)false)).booleanValue()) {
            return ((HttpSecurity)security.csrf().csrfTokenRepository((CsrfTokenRepository)this.cookieCsrfSignedTokenRepository()).requireCsrfProtectionMatcher((RequestMatcher)new CsrfRequestMatcher()).and()).addFilterAfter((Filter)new CsrfIncludeFilter(), CsrfFilter.class);
        }
        return (HttpSecurity)security.csrf().disable();
    }

    private HttpSecurity cors(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.cors().and();
    }
}

