/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.param;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

public class LogsParam {
    @QueryParam(value="from")
    @Parameter(description="Timestamp used to define the start date of the time window to query")
    private long from;
    @QueryParam(value="to")
    @Parameter(description="Timestamp used to define the end date of the time window to query")
    private long to;
    @Parameter(name="query", description="The expresion used to search for logs. It looks like 'transaction:123-456-789 AND uri=\\\\/path\\\\/to\\\\/resource* AND response-time:[100 TO 200]'. Reserved characters that must be escaped + - = && || > < ! ( ) { } [ ] ^ \" ~ * ? : \\ /")
    @QueryParam(value="query")
    private String query;
    @QueryParam(value="size")
    @DefaultValue(value="20")
    @Parameter(description="The number of data to retrieve")
    private int size;
    @QueryParam(value="page")
    @DefaultValue(value="1")
    private int page;
    @QueryParam(value="field")
    @Parameter(description="The field to query when doing `group_by` queries")
    private String field;
    @QueryParam(value="order")
    @Parameter(description="true means ASC order, false means DESC")
    private boolean order;

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean isOrder() {
        return this.order;
    }

    public void setOrder(boolean order) {
        this.order = order;
    }

    public void validate() throws WebApplicationException {
        if (this.from == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'from' is not valid").build());
        }
        if (this.to == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'to' is not valid").build());
        }
        if (this.from >= this.to) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'from' query parameter value must be greater than 'to'").build());
        }
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.size < 0) {
            this.size = 20;
        }
        if (this.size > 10000) {
            this.size = 10000;
        }
    }
}

