/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSAlgorithmFamilyJWSKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.TokenEntity;
import io.gravitee.rest.api.management.rest.resource.auth.AbstractAuthenticationResource;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@Path(value="/auth/cockpit")
public class CockpitAuthenticationResource
extends AbstractAuthenticationResource {
    protected static final String ORG_CLAIM = "org";
    protected static final String KID = "cockpit";
    protected static final String REDIRECT_URI_CLAIM = "redirect_uri";
    protected static final String ENVIRONMENT_CLAIM = "env";
    protected static final String API_CLAIM = "api";
    protected static final String APPLICATION_CLAIM = "app";
    private static final Logger LOGGER = LoggerFactory.getLogger(CockpitAuthenticationResource.class);
    private static final String COCKPIT_SOURCE = "cockpit";
    @Autowired
    protected MembershipService membershipService;
    @Autowired
    protected CookieGenerator cookieGenerator;
    private boolean enabled;
    private JWTProcessor<SecurityContext> jwtProcessor;
    @Autowired
    private UserService userService;
    @Autowired
    private Environment environment;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;

    @PostConstruct
    public void afterPropertiesSet() {
        this.enabled = this.getProperty("cockpit.enabled", "cloud.enabled", Boolean.class, false);
        if (this.enabled) {
            try {
                RSAKey rsaKey = new RSAKey.Builder((RSAPublicKey)this.getPublicKey()).keyID("cockpit").build();
                JWSAlgorithmFamilyJWSKeySelector jwsKeySelector = new JWSAlgorithmFamilyJWSKeySelector(JWSAlgorithm.Family.RSA, (JWKSource)new ImmutableJWKSet(new JWKSet((JWK)rsaKey)));
                DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
                this.jwtProcessor = jwtProcessor;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize cockpit filter", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response tokenExchange(@Context HttpServletRequest httpServletRequest, @QueryParam(value="token") String token, @Context HttpServletResponse httpResponse) {
        Response response;
        if (!this.enabled) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(token, null);
            String organizationId = jwtClaimsSet.getStringClaim(ORG_CLAIM);
            String environmentId = jwtClaimsSet.getStringClaim(ENVIRONMENT_CLAIM);
            GraviteeContext.fromExecutionContext((ExecutionContext)new ExecutionContext(organizationId, environmentId));
            UserEntity user = this.userService.findBySource(organizationId, "cockpit", jwtClaimsSet.getSubject(), true);
            Set authorities = this.authoritiesProvider.retrieveAuthorities(user.getId(), organizationId, environmentId);
            UserDetails userDetails = new UserDetails(user.getId(), "", (Collection)authorities);
            userDetails.setOrganizationId(user.getOrganizationId());
            userDetails.setEmail(user.getEmail());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, (Collection)authorities));
            super.connectUser(user, httpResponse);
            if ("PORTAL".equalsIgnoreCase(jwtClaimsSet.getStringClaim(APPLICATION_CLAIM))) {
                ServletServerHttpRequest request;
                TokenEntity tokenEntity = this.generateToken(user, 30);
                String url = this.installationAccessQueryService.getPortalAPIUrl(environmentId);
                if (url == null) {
                    request = new ServletServerHttpRequest(httpServletRequest);
                    UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).replacePath(this.getProperty("http.api.portal.entrypoint", "installation.api.proxyPath.portal", "/portal")).replaceQuery(null).build();
                    url = uriComponents.toUriString();
                }
                request = Response.temporaryRedirect((URI)new URI("%s/environments/%s/auth/console?token=%s".formatted(url, environmentId, tokenEntity.getToken()))).build();
                return request;
            }
            String apiCrossId = jwtClaimsSet.getStringClaim(API_CLAIM);
            String apiId = Optional.ofNullable(apiCrossId).flatMap(crossId -> this.apiSearchService.findIdByEnvironmentIdAndCrossId(environmentId, crossId)).orElse(null);
            String url = String.format("%s/#!/%s/%s", this.installationAccessQueryService.getConsoleUrl(organizationId), environmentId, apiId == null ? "" : String.format("apis/%s", apiId));
            Response response2 = Response.temporaryRedirect((URI)new URI(url)).build();
            return response2;
        }
        catch (UserNotFoundException e) {
            LOGGER.error("Authentication failed", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when trying to log user using cockpit.", (Throwable)e);
            response = Response.serverError().build();
            return response;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }

    private Key getPublicKey() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore trustStore = this.loadTrustStore();
        Certificate cert = trustStore.getCertificate(this.getProperty("cockpit.keystore.key.alias", "cloud.connector.ws.ssl.keystore.key.alias", "cockpit-client"));
        return cert.getPublicKey();
    }

    private KeyStore loadTrustStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keystore = KeyStore.getInstance(this.getProperty("cockpit.keystore.type", "cloud.connector.ws.ssl.keystore.type", null));
        try (InputStream is = new File(this.getProperty("cockpit.keystore.path", "cloud.connector.ws.ssl.keystore.path", null)).toURI().toURL().openStream();){
            String password = this.getProperty("cockpit.keystore.password", "cloud.connector.ws.ssl.keystore.password", null);
            keystore.load(is, null == password ? null : password.toCharArray());
        }
        return keystore;
    }

    private String getProperty(String property, String fallback, String defaultValue) {
        return this.getProperty(property, fallback, String.class, defaultValue);
    }

    <T> T getProperty(String property, String fallback, Class<T> targetType, T defaultValue) {
        Object value = this.environment.getProperty(property, targetType);
        if (value == null) {
            value = this.environment.getProperty(fallback, targetType);
        }
        return (T)(value != null ? value : defaultValue);
    }
}

