/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.management.rest.model.wrapper.RoleScopesLinkedHashMap;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleScopeResource;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Arrays;
import java.util.stream.Collectors;

@Tag(name="Roles")
public class RoleScopesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List availables role scopes")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of role scopes", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleScopesLinkedHashMap.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public RoleScopesLinkedHashMap getRoleScopes() {
        RoleScopesLinkedHashMap roles = new RoleScopesLinkedHashMap(4);
        roles.put(RoleScope.ORGANIZATION.name(), Arrays.stream(OrganizationPermission.values()).map(OrganizationPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.ENVIRONMENT.name(), Arrays.stream(EnvironmentPermission.values()).map(EnvironmentPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.API.name(), Arrays.stream(ApiPermission.values()).map(ApiPermission::getName).sorted().collect(Collectors.toList()));
        roles.put(RoleScope.APPLICATION.name(), Arrays.stream(ApplicationPermission.values()).map(ApplicationPermission::getName).sorted().collect(Collectors.toList()));
        return roles;
    }

    @Path(value="{scope}/roles")
    public RoleScopeResource getRoleScopeResource() {
        return (RoleScopeResource)this.resourceContext.getResource(RoleScopeResource.class);
    }
}

