/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.PortalMediaResource;
import io.gravitee.rest.api.management.rest.resource.PortalPagesResource;
import io.gravitee.rest.api.management.rest.resource.PortalRedirectResource;
import io.gravitee.rest.api.management.rest.resource.portal.PortalApisResource;
import io.gravitee.rest.api.management.rest.resource.portal.SocialIdentityProvidersResource;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.PortalConfigEntity;
import io.gravitee.rest.api.model.settings.PortalSettingsEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="Portal")
public class PortalResource {
    @Inject
    private ConfigService configService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the portal configuration", description="Every users can use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Portal configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=PortalConfigEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public PortalConfigEntity getPortalConfig() {
        return this.configService.getPortalConfig(GraviteeContext.getExecutionContext());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Save the portal configuration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated portal configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=PortalSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    @Deprecated
    public Response savePortalConfig(@Parameter(name="config", required=true) @NotNull PortalSettingsEntity portalSettingsEntity) {
        this.configService.save(GraviteeContext.getExecutionContext(), portalSettingsEntity);
        return Response.ok().entity((Object)portalSettingsEntity).build();
    }

    @Path(value="pages")
    public PortalPagesResource getPortalPagesResource() {
        return (PortalPagesResource)this.resourceContext.getResource(PortalPagesResource.class);
    }

    @Path(value="apis")
    public PortalApisResource getPortalApisResource() {
        return (PortalApisResource)this.resourceContext.getResource(PortalApisResource.class);
    }

    @Path(value="media")
    public PortalMediaResource getPortalMediaResource() {
        return (PortalMediaResource)this.resourceContext.getResource(PortalMediaResource.class);
    }

    @Deprecated
    @Path(value="identities")
    public SocialIdentityProvidersResource getSocialIdentityProvidersResource() {
        return (SocialIdentityProvidersResource)this.resourceContext.getResource(SocialIdentityProvidersResource.class);
    }

    @Path(value="redirect")
    public PortalRedirectResource getPortalRedirectResource() {
        return (PortalRedirectResource)this.resourceContext.getResource(PortalRedirectResource.class);
    }
}

