/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.mapper;

import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import java.sql.Date;

public class SubscriptionMapper {
    public static Subscription convert(SubscriptionEntity subscriptionEntity, String userDisplayName, GenericPlanEntity plan, ApplicationEntity application) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(Date.from(subscriptionEntity.getCreatedAt().toInstant()));
        subscription.setUpdatedAt(Date.from(subscriptionEntity.getUpdatedAt().toInstant()));
        subscription.setStartingAt(subscriptionEntity.getStartingAt() != null ? Date.from(subscriptionEntity.getStartingAt().toInstant()) : null);
        subscription.setEndingAt(subscriptionEntity.getEndingAt() != null ? Date.from(subscriptionEntity.getEndingAt().toInstant()) : null);
        subscription.setClosedAt(subscriptionEntity.getClosedAt() != null ? Date.from(subscriptionEntity.getClosedAt().toInstant()) : null);
        subscription.setPausedAt(subscriptionEntity.getPausedAt() != null ? Date.from(subscriptionEntity.getPausedAt().toInstant()) : null);
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt() != null ? Date.from(subscriptionEntity.getConsumerPausedAt().toInstant()) : null);
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt() != null ? Date.from(subscriptionEntity.getProcessedAt().toInstant()) : null);
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequestMessage());
        subscription.setReason(subscriptionEntity.getReasonMessage());
        subscription.setStatus(switch (subscriptionEntity.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.Status.PENDING -> SubscriptionStatus.PENDING;
            case SubscriptionEntity.Status.REJECTED -> SubscriptionStatus.REJECTED;
            case SubscriptionEntity.Status.ACCEPTED -> SubscriptionStatus.ACCEPTED;
            case SubscriptionEntity.Status.CLOSED -> SubscriptionStatus.CLOSED;
            case SubscriptionEntity.Status.PAUSED -> SubscriptionStatus.PAUSED;
        });
        subscription.setConsumerStatus(switch (subscriptionEntity.getConsumerStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.ConsumerStatus.STARTED -> SubscriptionConsumerStatus.STARTED;
            case SubscriptionEntity.ConsumerStatus.STOPPED -> SubscriptionConsumerStatus.STOPPED;
            case SubscriptionEntity.ConsumerStatus.FAILURE -> SubscriptionConsumerStatus.FAILURE;
        });
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), userDisplayName));
        subscription.setClientId(subscriptionEntity.getClientId());
        subscription.setMetadata(subscriptionEntity.getMetadata());
        subscription.setPlan(SubscriptionMapper.convertPlan(plan));
        subscription.setApplication(SubscriptionMapper.convertApplication(application));
        return subscription;
    }

    private static Subscription.Plan convertPlan(GenericPlanEntity genericPlan) {
        Subscription.Plan plan = new Subscription.Plan(genericPlan.getId(), genericPlan.getName());
        if (genericPlan.getPlanMode() == PlanMode.STANDARD) {
            plan.setSecurity(genericPlan.getPlanSecurity().getType());
        }
        return plan;
    }

    private static Subscription.Application convertApplication(ApplicationEntity application) {
        return new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName()), application.getApiKeyMode());
    }
}

