/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.util.Maps;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.TokenEntity;
import io.gravitee.rest.api.management.rest.model.TokenType;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractAuthenticationResource {
    public static final String CLIENT_ID_KEY = "client_id";
    public static final String REDIRECT_URI_KEY = "redirect_uri";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CODE_KEY = "code";
    public static final String GRANT_TYPE_KEY = "grant_type";
    public static final String AUTH_CODE = "authorization_code";
    public static final String CODE_VERIFIER_KEY = "code_verifier";
    public static final String TOKEN = "token";
    public static final String STATE = "state";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Autowired
    protected Environment environment;
    @Autowired
    protected UserService userService;
    @Autowired
    protected MembershipService membershipService;
    @Autowired
    protected CookieGenerator cookieGenerator;

    protected Map<String, Object> getResponseEntity(Response response) throws IOException {
        return this.getEntity(this.getResponseEntityAsString(response));
    }

    protected String getResponseEntityAsString(Response response) throws IOException {
        return (String)response.readEntity(String.class);
    }

    protected Map<String, Object> getEntity(String response) throws IOException {
        return (Map)MAPPER.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected Response connectUser(String userId, String state, HttpServletResponse servletResponse, String accessToken, String idToken) {
        UserEntity user = this.userService.connect(GraviteeContext.getExecutionContext(), userId);
        return this.connectUserInternal(user, state, servletResponse, accessToken, idToken);
    }

    protected void connectUser(UserEntity user, HttpServletResponse servletResponse) {
        this.connectUserInternal(user, null, servletResponse, null, null);
    }

    protected Response connectUserInternal(UserEntity user, String state, HttpServletResponse servletResponse, String accessToken, String idToken) {
        TokenEntity tokenEntity = this.generateToken(user, state, accessToken, idToken, null);
        Cookie bearerCookie = this.cookieGenerator.generate("Auth-Graviteeio-APIM", "Bearer%20" + tokenEntity.getToken());
        servletResponse.addCookie(bearerCookie);
        return Response.ok((Object)tokenEntity).build();
    }

    protected TokenEntity generateToken(UserEntity user, Integer expireAfter) {
        return this.generateToken(user, null, null, null, expireAfter);
    }

    protected TokenEntity generateToken(UserEntity user, String state, String accessToken, String idToken, Integer expireAfter) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        List authorities = userDetails.getAuthorities().stream().map(authority -> Maps.builder().put((Object)"authority", (Object)authority.getAuthority()).build()).collect(Collectors.toList());
        Set userRoles = this.membershipService.getRoles(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userDetails.getId());
        if (!userRoles.isEmpty()) {
            userRoles.forEach(role -> authorities.add(Maps.builder().put((Object)"authority", (Object)(role.getScope().toString() + ":" + role.getName())).build()));
        }
        Algorithm algorithm = Algorithm.HMAC256((String)this.environment.getProperty("jwt.secret"));
        Date issueAt = new Date();
        Instant expireAt = issueAt.toInstant().plus(Duration.ofSeconds(expireAfter != null ? (long)expireAfter.intValue() : (long)((Integer)this.environment.getProperty("jwt.expire-after", Integer.class, (Object)604800)).intValue()));
        String token = JWT.create().withIssuer(this.environment.getProperty("jwt.issuer", "gravitee-management-auth")).withIssuedAt(issueAt).withExpiresAt(Date.from(expireAt)).withSubject(user.getId()).withClaim("permissions", authorities).withClaim("email", user.getEmail()).withClaim("firstname", user.getFirstname()).withClaim("lastname", user.getLastname()).withClaim("org", user.getOrganizationId()).withJWTId(UUID.randomUUID().toString()).sign(algorithm);
        TokenEntity tokenEntity = new TokenEntity();
        tokenEntity.setType(TokenType.BEARER);
        tokenEntity.setToken(token);
        if (idToken != null) {
            tokenEntity.setAccessToken(accessToken);
            tokenEntity.setIdToken(idToken);
        }
        if (state != null && !state.isEmpty()) {
            tokenEntity.setState(state);
        }
        return tokenEntity;
    }
}

