/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewTenantEntity;
import io.gravitee.rest.api.model.TenantEntity;
import io.gravitee.rest.api.model.TenantReferenceType;
import io.gravitee.rest.api.model.UpdateTenantEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.TenantService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="Tenants")
public class TenantsResource
extends AbstractResource {
    @Inject
    private TenantService tenantService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List tenants")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of tenants", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TenantEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<TenantEntity> getTenants() {
        return this.tenantService.findByReference(GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a tenant", description="User must have the MANAGEMENT_TENANT[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of tenants", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TenantEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.CREATE})})
    public List<TenantEntity> createTenants(@Valid @NotNull List<NewTenantEntity> tenant) {
        return this.tenantService.create(GraviteeContext.getExecutionContext(), tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a tenant", description="User must have the MANAGEMENT_TENANT[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of tenants", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TenantEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.UPDATE})})
    public List<TenantEntity> updateTenants(@Valid @NotNull List<UpdateTenantEntity> tenant) {
        return this.tenantService.update(GraviteeContext.getExecutionContext(), tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }

    @Path(value="{tenant}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a tenant", description="User must have the MANAGEMENT_TENANT[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of tenants", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TenantEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TENANT, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_TENANT, acls={RolePermissionAction.DELETE})})
    public void deleteTenant(@PathParam(value="tenant") String tenant) {
        this.tenantService.delete(GraviteeContext.getExecutionContext(), tenant, GraviteeContext.getCurrentOrganization(), TenantReferenceType.ORGANIZATION);
    }
}

