/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ResourceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Plugins")
public class ResourceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ResourceService resourceService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a resource", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Resource plugin", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlatformPluginEntity.class))}), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PlatformPluginEntity getResource(@PathParam(value="resource") String resource) {
        return this.resourceService.findById(resource);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a resource's schema", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getResourceSchema(@PathParam(value="resource") String resource) {
        this.resourceService.findById(resource);
        return this.resourceService.getSchema(resource);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @Operation(summary="Get a resource's documentation", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getResourceDoc(@PathParam(value="resource") String resource) {
        this.resourceService.findById(resource);
        return this.resourceService.getDocumentation(resource);
    }
}

