/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.PromotionResource;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="Promotions")
public class PromotionsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PromotionService promotionService;

    @Path(value="{promotion}")
    public PromotionResource getPolicyResource() {
        return (PromotionResource)this.resourceContext.getResource(PromotionResource.class);
    }

    @POST
    @Path(value="_search")
    @Produces(value={"application/json"})
    @Operation(summary="Search for Promotion")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List promotions matching request parameters", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PromotionEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response searchPromotions(@Parameter(name="statuses", required=true) @NotNull @QueryParam(value="statuses") List<String> statuses, @Parameter(name="apiId", required=true) @NotNull @QueryParam(value="apiId") String apiId) {
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(statuses.stream().map(PromotionEntityStatus::valueOf).collect(Collectors.toList()));
        promotionQuery.setApiId(apiId);
        List promotions = this.promotionService.search(promotionQuery, (Sortable)new SortableImpl("created_at", false), null).getContent();
        return Response.ok().entity((Object)promotions).build();
    }
}

