/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.settings.PortalSettingsEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="Settings")
public class PortalSettingsResource {
    @Inject
    private ConfigService configService;
    @Inject
    private EnvironmentService environmentService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the portal settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Portal configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=PortalSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.READ})})
    public PortalSettingsEntity getPortalSettings() {
        return this.configService.getPortalSettings(GraviteeContext.getExecutionContext());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Save the portal settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated portal settings", content={@Content(mediaType="application/json", schema=@Schema(implementation=PortalSettingsEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_SETTINGS, acls={RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})})
    public Response savePortalSettings(@Parameter(name="config", required=true) @Valid @NotNull PortalSettingsEntity portalSettingsEntity) {
        this.environmentService.findById(GraviteeContext.getCurrentEnvironment());
        this.configService.save(GraviteeContext.getExecutionContext(), portalSettingsEntity);
        return Response.ok().entity((Object)portalSettingsEntity).build();
    }
}

