/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.wrapper.TicketEntityPage;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.TicketsParam;
import io.gravitee.rest.api.model.NewTicketEntity;
import io.gravitee.rest.api.model.TicketEntity;
import io.gravitee.rest.api.model.api.TicketQuery;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.TicketService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Platform Tickets")
public class PlatformTicketsResource
extends AbstractResource {
    @Inject
    private TicketService ticketService;

    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Create a platform ticket")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Ticket succesfully created"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createPlatformTicket(@Valid @NotNull NewTicketEntity ticketEntity) {
        this.ticketService.create(GraviteeContext.getExecutionContext(), this.getAuthenticatedUser(), ticketEntity, GraviteeContext.getCurrentOrganization(), ParameterReferenceType.ORGANIZATION);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Search for platform tickets written by current user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List platform tickets written by current user", content={@Content(mediaType="application/json", schema=@Schema(implementation=TicketEntityPage.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public TicketEntityPage getTickets(@Valid @BeanParam Pageable pageable, @Valid @BeanParam TicketsParam ticketsParam) {
        TicketQuery query = new TicketQuery();
        query.setApi(ticketsParam.getApi());
        query.setApplication(ticketsParam.getApplication());
        query.setApi(ticketsParam.getApi());
        query.setFromUser(this.getAuthenticatedUser());
        SortableImpl sortable = null;
        if (ticketsParam.getOrder() != null) {
            sortable = new SortableImpl(ticketsParam.getOrder().getField(), ticketsParam.getOrder().isOrder());
        }
        return new TicketEntityPage((Page<TicketEntity>)this.ticketService.search(GraviteeContext.getExecutionContext(), query, (Sortable)sortable, pageable.toPageable()));
    }

    @GET
    @Path(value="/{ticket}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific ticket")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Get a platform ticket", content={@Content(mediaType="application/json", schema=@Schema(implementation=TicketEntity.class))}), @ApiResponse(responseCode="404", description="Ticket not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getTicket(@PathParam(value="ticket") String ticketId) {
        TicketEntity ticketEntity = this.ticketService.findById(GraviteeContext.getExecutionContext(), ticketId);
        return Response.ok((Object)ticketEntity).build();
    }
}

