/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.FetcherResource;
import io.gravitee.rest.api.management.rest.resource.param.FetchersParam;
import io.gravitee.rest.api.model.FetcherEntity;
import io.gravitee.rest.api.model.FetcherListItem;
import io.gravitee.rest.api.service.FetcherService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(name="Plugins")
public class FetchersResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private FetcherService fetcherService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List of fetcher plugins")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of fetchers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=FetcherListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<FetcherListItem> getFetchers(@BeanParam FetchersParam params) {
        Stream<FetcherListItem> stream = this.fetcherService.findAll(params.isOnlyFilesFetchers()).stream().map(this::convert);
        if (params != null && params.getExpand() != null && !params.getExpand().isEmpty()) {
            Iterator iterator = params.getExpand().iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = (String)iterator.next()) {
                    case "schema": {
                        stream = stream.map(fetcherListItem -> {
                            fetcherListItem.setSchema(this.fetcherService.getSchema(fetcherListItem.getId()));
                            return fetcherListItem;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(FetcherListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{fetcher}")
    public FetcherResource getFetcherResource() {
        return (FetcherResource)this.resourceContext.getResource(FetcherResource.class);
    }

    private FetcherListItem convert(FetcherEntity fetcher) {
        FetcherListItem item = new FetcherListItem();
        item.setId(fetcher.getId());
        item.setName(fetcher.getName());
        item.setDescription(fetcher.getDescription());
        item.setVersion(fetcher.getVersion());
        return item;
    }
}

