/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.model.FetcherEntity;
import io.gravitee.rest.api.service.FetcherService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Plugins")
public class FetcherResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private FetcherService fetcherService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a fetcher plugin")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Fetcher", content={@Content(mediaType="application/json", schema=@Schema(implementation=FetcherEntity.class))}), @ApiResponse(responseCode="404", description="Fetcher not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public FetcherEntity getFetcher(@PathParam(value="fetcher") String fetcher) {
        return (FetcherEntity)this.fetcherService.findById(fetcher);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a fetcher plugin's schema")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Fetcher's schema", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="404", description="Fetcher not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String getFetcherSchema(@PathParam(value="fetcher") String fetcher) {
        this.fetcherService.findById(fetcher);
        return this.fetcherService.getSchema(fetcher);
    }
}

