/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.PermissionMap;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.AlertsResource;
import io.gravitee.rest.api.management.rest.resource.ApisResource;
import io.gravitee.rest.api.management.rest.resource.ApplicationsResource;
import io.gravitee.rest.api.management.rest.resource.AuditResource;
import io.gravitee.rest.api.management.rest.resource.ConnectorsResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentAnalyticsResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentConfigurationResource;
import io.gravitee.rest.api.management.rest.resource.FetchersResource;
import io.gravitee.rest.api.management.rest.resource.InstancesResource;
import io.gravitee.rest.api.management.rest.resource.MessagesResource;
import io.gravitee.rest.api.management.rest.resource.NotifiersResource;
import io.gravitee.rest.api.management.rest.resource.PlatformResource;
import io.gravitee.rest.api.management.rest.resource.PlatformTicketsResource;
import io.gravitee.rest.api.management.rest.resource.PoliciesResource;
import io.gravitee.rest.api.management.rest.resource.PortalEntrypointsResource;
import io.gravitee.rest.api.management.rest.resource.PortalResource;
import io.gravitee.rest.api.management.rest.resource.PortalSettingsResource;
import io.gravitee.rest.api.management.rest.resource.PromotionTargetsResource;
import io.gravitee.rest.api.management.rest.resource.ResourcesResource;
import io.gravitee.rest.api.management.rest.resource.RestrictedDomainsResource;
import io.gravitee.rest.api.management.rest.resource.ServicesDiscoveryResource;
import io.gravitee.rest.api.management.rest.resource.SubscriptionsResource;
import io.gravitee.rest.api.management.rest.resource.auth.OAuth2AuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.organization.CurrentUserResource;
import io.gravitee.rest.api.management.rest.resource.organization.UsersResource;
import io.gravitee.rest.api.management.rest.resource.search.SearchResource;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EnvironmentResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private IdentityProviderService identityProviderService;
    @Inject
    private IdentityProviderActivationService identityProviderActivationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get an Environment", tags={"Environment"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Found Environment", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEnvironment() {
        return Response.ok((Object)this.environmentService.findById(GraviteeContext.getCurrentEnvironment())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/identities")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.READ})})
    @Operation(summary="Get the list of identity provider activations for current environment", description="User must have the ENVIRONMENT_IDENTITY_PROVIDER_ACTIVATION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List identity provider activations for current environment", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=IdentityProviderActivationEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Set<IdentityProviderActivationEntity> getIdentityProviderActivations() {
        return this.identityProviderActivationService.findAllByTarget(new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentEnvironment(), IdentityProviderActivationReferenceType.ENVIRONMENT));
    }

    @PUT
    @Path(value="/identities")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.CREATE, RolePermissionAction.DELETE, RolePermissionAction.UPDATE})})
    @Operation(summary="Update available environment identities", tags={"Environment"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Environment successfully updated"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateEnvironmentIdentities(List<IdentityProviderActivationEntity> identityProviderActivations) {
        this.identityProviderActivationService.updateTargetIdp(GraviteeContext.getExecutionContext(), new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentEnvironment(), IdentityProviderActivationReferenceType.ENVIRONMENT), identityProviderActivations.stream().filter(ipa -> {
            IdentityProviderEntity idp = this.identityProviderService.findById(ipa.getIdentityProvider());
            return GraviteeContext.getCurrentOrganization().equals(idp.getOrganization());
        }).map(IdentityProviderActivationEntity::getIdentityProvider).collect(Collectors.toList()));
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/permissions")
    @Operation(summary="Get permissions for the current user on the environment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Current user permissions on environment", content={@Content(mediaType="application/json", schema=@Schema(implementation=PermissionMap.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEnvironmentPermissions() {
        HashMap<String, char[]> permissions = new HashMap<String, char[]>();
        if (this.isAuthenticated()) {
            String username = this.getAuthenticatedUser();
            EnvironmentEntity environmentEntity = this.environmentService.findById(GraviteeContext.getCurrentEnvironment());
            if (this.isAdmin()) {
                char[] rights = new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()};
                for (EnvironmentPermission perm : EnvironmentPermission.values()) {
                    permissions.put(perm.getName(), rights);
                }
            } else {
                permissions.putAll(this.membershipService.getUserMemberPermissions(GraviteeContext.getExecutionContext(), environmentEntity, username));
            }
        }
        return Response.ok(permissions).build();
    }

    @Path(value="alerts")
    public AlertsResource getAlertsResource() {
        return (AlertsResource)this.resourceContext.getResource(AlertsResource.class);
    }

    @Path(value="apis")
    public ApisResource getApisResource() {
        return (ApisResource)this.resourceContext.getResource(ApisResource.class);
    }

    @Path(value="applications")
    public ApplicationsResource getApplicationsResource() {
        return (ApplicationsResource)this.resourceContext.getResource(ApplicationsResource.class);
    }

    @Path(value="configuration")
    public EnvironmentConfigurationResource getConfigurationResource() {
        return (EnvironmentConfigurationResource)this.resourceContext.getResource(EnvironmentConfigurationResource.class);
    }

    @Deprecated
    @Path(value="user")
    public CurrentUserResource getCurrentUserResource() {
        return (CurrentUserResource)this.resourceContext.getResource(CurrentUserResource.class);
    }

    @Path(value="subscriptions")
    public SubscriptionsResource getSubscriptionsResource() {
        return (SubscriptionsResource)this.resourceContext.getResource(SubscriptionsResource.class);
    }

    @Path(value="audit")
    public AuditResource getAuditResource() {
        return (AuditResource)this.resourceContext.getResource(AuditResource.class);
    }

    @Path(value="portal")
    public PortalResource getPortalResource() {
        return (PortalResource)this.resourceContext.getResource(PortalResource.class);
    }

    @Deprecated
    @Path(value="auth/oauth2/{identity}")
    public OAuth2AuthenticationResource getOAuth2AuthenticationResource() {
        return (OAuth2AuthenticationResource)this.resourceContext.getResource(OAuth2AuthenticationResource.class);
    }

    @Deprecated
    @Path(value="users")
    public UsersResource getUsersResource() {
        return (UsersResource)this.resourceContext.getResource(UsersResource.class);
    }

    @Deprecated
    @Path(value="search")
    public SearchResource getSearchResource() {
        return (SearchResource)this.resourceContext.getResource(SearchResource.class);
    }

    @Path(value="fetchers")
    public FetchersResource getFetchersResource() {
        return (FetchersResource)this.resourceContext.getResource(FetchersResource.class);
    }

    @Path(value="policies")
    public PoliciesResource getPoliciesResource() {
        return (PoliciesResource)this.resourceContext.getResource(PoliciesResource.class);
    }

    @Path(value="resources")
    public ResourcesResource getResourcesResource() {
        return (ResourcesResource)this.resourceContext.getResource(ResourcesResource.class);
    }

    @Path(value="services-discovery")
    public ServicesDiscoveryResource getServicesDiscoveryResource() {
        return (ServicesDiscoveryResource)this.resourceContext.getResource(ServicesDiscoveryResource.class);
    }

    @Path(value="connectors")
    public ConnectorsResource getConnectorsResource() {
        return (ConnectorsResource)this.resourceContext.getResource(ConnectorsResource.class);
    }

    @Path(value="instances")
    public InstancesResource getInstancesResource() {
        return (InstancesResource)this.resourceContext.getResource(InstancesResource.class);
    }

    @Path(value="platform")
    public PlatformResource getPlatformResource() {
        return (PlatformResource)this.resourceContext.getResource(PlatformResource.class);
    }

    @Path(value="messages")
    public MessagesResource getMessagesResource() {
        return (MessagesResource)this.resourceContext.getResource(MessagesResource.class);
    }

    @Path(value="tickets")
    public PlatformTicketsResource getPlatformTicketsResource() {
        return (PlatformTicketsResource)this.resourceContext.getResource(PlatformTicketsResource.class);
    }

    @Path(value="entrypoints")
    public PortalEntrypointsResource getPortalEntryPointsResource() {
        return (PortalEntrypointsResource)this.resourceContext.getResource(PortalEntrypointsResource.class);
    }

    @Path(value="notifiers")
    public NotifiersResource getNotifiersResource() {
        return (NotifiersResource)this.resourceContext.getResource(NotifiersResource.class);
    }

    @Path(value="settings")
    public PortalSettingsResource getPortalSettingsResource() {
        return (PortalSettingsResource)this.resourceContext.getResource(PortalSettingsResource.class);
    }

    @Path(value="analytics")
    public EnvironmentAnalyticsResource getEnvironmentAnalyticsResource() {
        return (EnvironmentAnalyticsResource)this.resourceContext.getResource(EnvironmentAnalyticsResource.class);
    }

    @Path(value="promotion-targets")
    public PromotionTargetsResource getPromotionTargetsResource() {
        return (PromotionTargetsResource)this.resourceContext.getResource(PromotionTargetsResource.class);
    }

    @Path(value="restrictedDomains")
    public RestrictedDomainsResource getRestrictedDomainsResource() {
        return (RestrictedDomainsResource)this.resourceContext.getResource(RestrictedDomainsResource.class);
    }
}

