/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.model.wrapper.PortalNotificationPageResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.notification.PortalNotificationEntity;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.exceptions.PortalNotificationNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@Tag(name="User Notifications")
public class UserNotificationsResource
extends AbstractResource {
    @Autowired
    private PortalNotificationService portalNotificationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List user's notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's notifications", content={@Content(mediaType="application/json", schema=@Schema(implementation=PortalNotificationPageResult.class))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public PortalNotificationPageResult getUserNotifications() {
        List<PortalNotificationEntity> notifications = this.portalNotificationService.findByUser(this.getAuthenticatedUser()).stream().sorted(Comparator.comparing(PortalNotificationEntity::getCreatedAt)).collect(Collectors.toList());
        return new PortalNotificationPageResult((Collection<PortalNotificationEntity>)notifications);
    }

    @DELETE
    @Operation(summary="Delete all user's notifications")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notifications successfully deleted"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteAllUserNotifications() {
        this.portalNotificationService.deleteAll(this.getAuthenticatedUser());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="{notification}")
    @DELETE
    @Operation(summary="Delete a single user's notification")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notification successfully deleted"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteUserNotification(@PathParam(value="notification") String notificationId) {
        List userNotifications = this.portalNotificationService.findByUser(this.getAuthenticatedUser());
        userNotifications.stream().map(PortalNotificationEntity::getId).filter(id -> id.equalsIgnoreCase(notificationId)).findAny().orElseThrow(() -> new PortalNotificationNotFoundException(notificationId));
        this.portalNotificationService.delete(notificationId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

