/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidKeyException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.JWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.resolver.PublicKeyResolver;
import java.net.URL;

public class RemoteJWKSourceResolver<C extends SecurityContext>
implements JWKSourceResolver<C> {
    private final String url;

    public RemoteJWKSourceResolver(PublicKeyResolver publicKeyResolver) {
        this.url = publicKeyResolver.resolve();
        if (this.url == null) {
            throw new InvalidKeyException("JWKS URL can not be null");
        }
    }

    @Override
    public JWKSource<C> resolve() {
        try {
            return new RemoteJWKSet(new URL(this.url));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

