/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidKeyException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.JWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.resolver.PublicKeyResolver;

public class MACJWKSourceResolver<C extends SecurityContext>
implements JWKSourceResolver<C> {
    private final JWK jwk;

    private MACJWKSourceResolver(String secretKey) {
        if (secretKey == null) {
            throw new InvalidKeyException("Verification key can't be null");
        }
        this.jwk = new OctetSequenceKey.Builder(secretKey.getBytes()).build();
    }

    public MACJWKSourceResolver(PublicKeyResolver publicKeyResolver) {
        this(publicKeyResolver.resolve());
    }

    @Override
    public JWKSource<C> resolve() {
        try {
            return new ImmutableJWKSet(new JWKSet(this.jwk));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

