/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationDefaultReferenceId;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@Tag(name="Portal Notifications")
public class PortalNotificationSettingsResource
extends AbstractResource {
    @Inject
    private PortalNotificationConfigService portalNotificationConfigService;
    @Inject
    private GenericNotificationConfigService genericNotificationConfigService;

    @GET
    @Operation(summary="Get notification settings")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<Object> getPortalNotificationSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.add(this.portalNotificationConfigService.findById(this.getAuthenticatedUser(), NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name()));
        if (this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.ENVIRONMENT_NOTIFICATION, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE)) {
            settings.addAll(this.genericNotificationConfigService.findByReference(NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name()));
        }
        return settings;
    }

    @POST
    @Operation(summary="Create notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Object createPortalNotificationSetting(GenericNotificationConfigEntity config) {
        if (!NotificationReferenceType.PORTAL.name().equals(config.getReferenceType())) {
            throw new ForbiddenAccessException();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && this.hasPermission(executionContext, RolePermission.ENVIRONMENT_NOTIFICATION, RolePermissionAction.CREATE)) {
            return this.genericNotificationConfigService.create(config);
        }
        if (config.getConfigType().equals((Object)NotificationConfigType.PORTAL) && this.hasPermission(executionContext, RolePermission.ENVIRONMENT_NOTIFICATION, RolePermissionAction.READ)) {
            return this.portalNotificationConfigService.save(this.convert(config));
        }
        throw new ForbiddenAccessException();
    }

    @PUT
    @Path(value="{notificationId}")
    @Operation(summary="Update generic notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_NOTIFICATION, acls={RolePermissionAction.UPDATE})})
    public GenericNotificationConfigEntity updateGenericNotificationSettings(@PathParam(value="notificationId") String notificationId, GenericNotificationConfigEntity config) {
        if (!(PortalNotificationDefaultReferenceId.DEFAULT.name().equals(config.getReferenceId()) && NotificationReferenceType.PORTAL.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.GENERIC) && notificationId.equals(config.getId()))) {
            throw new ForbiddenAccessException();
        }
        return this.genericNotificationConfigService.update(config);
    }

    @PUT
    @Operation(summary="Update portal notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_NOTIFICATION, acls={RolePermissionAction.READ})})
    public PortalNotificationConfigEntity updatePortalNotificationSettings(PortalNotificationConfigEntity config) {
        if (!(PortalNotificationDefaultReferenceId.DEFAULT.name().equals(config.getReferenceId()) && NotificationReferenceType.PORTAL.name().equals(config.getReferenceType()) && config.getConfigType().equals((Object)NotificationConfigType.PORTAL))) {
            throw new ForbiddenAccessException();
        }
        config.setUser(this.getAuthenticatedUser());
        return this.portalNotificationConfigService.save(config);
    }

    @DELETE
    @Path(value="{notificationId}")
    @Operation(summary="Delete notification settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_NOTIFICATION, acls={RolePermissionAction.DELETE})})
    public Response deleteNotificationSettings(@PathParam(value="notificationId") String notificationId) {
        this.genericNotificationConfigService.delete(notificationId);
        return Response.noContent().build();
    }

    private PortalNotificationConfigEntity convert(GenericNotificationConfigEntity generic) {
        PortalNotificationConfigEntity portalNotificationConfigEntity = new PortalNotificationConfigEntity();
        portalNotificationConfigEntity.setConfigType(generic.getConfigType());
        portalNotificationConfigEntity.setReferenceType(generic.getReferenceType());
        portalNotificationConfigEntity.setReferenceId(generic.getReferenceId());
        portalNotificationConfigEntity.setUser(this.getAuthenticatedUser());
        portalNotificationConfigEntity.setHooks(generic.getHooks());
        return portalNotificationConfigEntity;
    }
}

