/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.InvitationEntity;
import io.gravitee.rest.api.model.InvitationReferenceType;
import io.gravitee.rest.api.model.NewInvitationEntity;
import io.gravitee.rest.api.model.UpdateInvitationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.InvitationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.GroupInvitationForbiddenException;
import io.gravitee.rest.api.service.exceptions.GroupMembersLimitationExceededException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;

@Tag(name="Group Invitations")
public class GroupInvitationsResource
extends AbstractResource {
    @Inject
    private InvitationService invitationService;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @Parameter(name="group", hidden=true)
    private String group;

    @GET
    @Operation(summary="List existing invitations of a group", description="User must have the GROUP_INVITATION[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ, RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.READ})})
    public List<InvitationEntity> getGroupInvitations() {
        return this.invitationService.findByReference(InvitationReferenceType.GROUP, this.group);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an invitation to join a group", description="User must have the GROUP_INVITATION[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.CREATE})})
    public InvitationEntity createGroupInvitation(@Valid @NotNull NewInvitationEntity invitationEntity) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GroupEntity groupEntity = this.groupService.findById(executionContext, this.group);
        boolean hasPermission = this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE});
        if (!hasPermission) {
            if (groupEntity.getMaxInvitation() != null && this.groupService.getNumberOfMembers(executionContext, this.group) >= groupEntity.getMaxInvitation()) {
                throw new GroupMembersLimitationExceededException(groupEntity.getMaxInvitation().intValue());
            }
            if (!groupEntity.isEmailInvitation()) {
                throw new GroupInvitationForbiddenException(GroupInvitationForbiddenException.Type.EMAIL, this.group);
            }
        }
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return this.invitationService.create(executionContext, invitationEntity);
    }

    @Path(value="{invitation}")
    @PUT
    @Operation(summary="Update an invitation to join a group", description="User must have the GROUP_INVITATION[UPDATE] permission to use this service")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.UPDATE})})
    public InvitationEntity updateGroupInvitation(@PathParam(value="invitation") String invitation, @Valid @NotNull UpdateInvitationEntity invitationEntity) {
        invitationEntity.setId(invitation);
        invitationEntity.setReferenceType(InvitationReferenceType.GROUP);
        invitationEntity.setReferenceId(this.group);
        return this.invitationService.update(invitationEntity);
    }

    @Path(value="{invitation}")
    @DELETE
    @Operation(summary="Delete an invitation to join a group", description="User must have the GROUP_INVITATION[DELETE] permission to use this service")
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE, RolePermissionAction.CREATE}), @Permission(value=RolePermission.GROUP_INVITATION, acls={RolePermissionAction.DELETE})})
    public void deleteGroupInvitation(@PathParam(value="invitation") String invitation) {
        this.invitationService.delete(invitation, this.group);
    }
}

