/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentResource;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;

public class EnvironmentsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EnvironmentService environmentService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List available environments for current user organization")
    public Collection<EnvironmentEntity> getEnvironments() {
        return this.environmentService.findByUser(GraviteeContext.getCurrentOrganization(), this.getAuthenticatedUserOrNull());
    }

    @Path(value="{envId}")
    public EnvironmentResource getEnvironmentResource(@PathParam(value="envId") @Parameter(name="envId", required=true, description="The ID of the environment", schema=@Schema(defaultValue="DEFAULT")) String envId) {
        return (EnvironmentResource)this.resourceContext.getResource(EnvironmentResource.class);
    }
}

