/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.apim.core.debug.use_case.DebugApiUseCase;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.mapper.DebugApiMapper;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiAlertsResource;
import io.gravitee.rest.api.management.rest.resource.ApiAnalyticsResource;
import io.gravitee.rest.api.management.rest.resource.ApiAuditResource;
import io.gravitee.rest.api.management.rest.resource.ApiDefinitionContextResource;
import io.gravitee.rest.api.management.rest.resource.ApiDefinitionResource;
import io.gravitee.rest.api.management.rest.resource.ApiEventsResource;
import io.gravitee.rest.api.management.rest.resource.ApiGroupsResource;
import io.gravitee.rest.api.management.rest.resource.ApiHealthResource;
import io.gravitee.rest.api.management.rest.resource.ApiLogsResource;
import io.gravitee.rest.api.management.rest.resource.ApiMembersResource;
import io.gravitee.rest.api.management.rest.resource.ApiMetadataResource;
import io.gravitee.rest.api.management.rest.resource.ApiNotificationSettingsResource;
import io.gravitee.rest.api.management.rest.resource.ApiPagesResource;
import io.gravitee.rest.api.management.rest.resource.ApiPlansResource;
import io.gravitee.rest.api.management.rest.resource.ApiQualityRulesResource;
import io.gravitee.rest.api.management.rest.resource.ApiRatingResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscribersResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionsResource;
import io.gravitee.rest.api.management.rest.resource.param.LifecycleAction;
import io.gravitee.rest.api.management.rest.resource.param.ReviewAction;
import io.gravitee.rest.api.management.rest.resource.param.kubernetes.v1alpha1.ApiExportParam;
import io.gravitee.rest.api.model.ApiQualityMetricsEntity;
import io.gravitee.rest.api.model.ApiStateEntity;
import io.gravitee.rest.api.model.DebugApiEntity;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MessageEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.RollbackApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.kubernetes.v1alpha1.ApiExportQuery;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionRequestEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.rest.annotation.GraviteeLicenseFeature;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiExportService;
import io.gravitee.rest.api.service.JsonPatchService;
import io.gravitee.rest.api.service.MessageService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.QualityMetricsService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

@Tag(name="APIs")
public class ApiResource
extends AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiResource.class);
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;
    @Inject
    private QualityMetricsService qualityMetricsService;
    @Inject
    private MessageService messageService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private SwaggerService swaggerService;
    @Inject
    private PromotionService promotionService;
    @Inject
    protected ApiDuplicatorService apiDuplicatorService;
    @Inject
    protected JsonPatchService jsonPatchService;
    @Inject
    protected ApiExportService apiExportService;
    @Inject
    protected DebugApiUseCase debugApiUseCase;
    @PathParam(value="api")
    @Parameter(name="api", required=true, description="The ID of the API")
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the API", description="User must have the READ permission on the API_DEFINITION to use this service on a private API.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApi() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        if (!this.canManageApi((GenericApiEntity)apiEntity)) {
            throw new ForbiddenAccessException();
        }
        if (this.hasPermission(executionContext, RolePermission.API_DEFINITION, this.api, RolePermissionAction.READ)) {
            this.setPictures(apiEntity);
        } else {
            this.filterSensitiveData(apiEntity);
        }
        return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
    }

    private void setPictures(ApiEntity apiEntity) {
        UriBuilder uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("picture");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setPictureUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setPicture(null);
        uriBuilder = this.uriInfo.getAbsolutePathBuilder().path("background");
        uriBuilder.queryParam("hash", new Object[]{apiEntity.getUpdatedAt().getTime()});
        apiEntity.setBackgroundUrl(uriBuilder.build(new Object[0]).toString());
        apiEntity.setBackground(null);
    }

    @GET
    @Path(value="picture")
    @Operation(summary="Get the API's picture", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API's picture", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiPicture(@Context Request request) throws ApiNotFoundException {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        return this.getImageResponse(executionContext, request, this.apiService.getPicture(executionContext, this.api));
    }

    @GET
    @Path(value="background")
    @Operation(summary="Get the API's background", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API's background", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiBackground(@Context Request request) throws ApiNotFoundException {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        return this.getImageResponse(executionContext, request, this.apiService.getBackground(executionContext, this.api));
    }

    private Response getImageResponse(ExecutionContext executionContext, Request request, InlinePictureEntity image) {
        this.canReadApi(executionContext, this.api);
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        if (image == null || image.getContent() == null) {
            return Response.ok().cacheControl(cc).build();
        }
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }

    @POST
    @Operation(summary="Manage the API's lifecycle", description="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response doApiLifecycleAction(@Context HttpHeaders headers, @Parameter(required=true) @QueryParam(value="action") LifecycleAction action) {
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        if (action == null) {
            throw new BadRequestException("Valid LifecycleAction is required");
        }
        ApiEntity apiEntity = (ApiEntity)responseApi.getEntity();
        ApiEntity updatedApi = null;
        switch (action) {
            case START: {
                this.checkApiLifeCycle(apiEntity, action);
                updatedApi = this.apiService.start(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser());
                break;
            }
            case STOP: {
                this.checkApiLifeCycle(apiEntity, action);
                updatedApi = this.apiService.stop(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser());
            }
        }
        return Response.noContent().tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update the API", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.API_GATEWAY_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApi(@Context HttpHeaders headers, @Parameter(name="api", required=true) @Valid @NotNull UpdateApiEntity apiToUpdate) {
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        try {
            ImageUtils.verify((String)apiToUpdate.getPicture());
            ImageUtils.verify((String)apiToUpdate.getBackground());
        }
        catch (InvalidImageException e) {
            LOGGER.warn("Invalid image format", (Throwable)e);
            throw new BadRequestException("Invalid image format : " + e.getMessage());
        }
        ApiEntity currentApi = (ApiEntity)responseApi.getEntity();
        if (!(this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_GATEWAY_DEFINITION, this.api, RolePermissionAction.UPDATE) || Objects.equals(currentApi.getPrimaryOwner().getId(), this.getAuthenticatedUser()) || this.isAdmin())) {
            apiToUpdate.getProxy().setVirtualHosts(currentApi.getProxy().getVirtualHosts());
        }
        ApiEntity updatedApi = this.apiService.update(GraviteeContext.getExecutionContext(), this.api, apiToUpdate, true);
        this.setPictures(updatedApi);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @DELETE
    @Operation(summary="Delete the API", description="User must have the DELETE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="API successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.DELETE})})
    public Response deleteApi(@QueryParam(value="closePlans") boolean closePlans) {
        this.apiService.delete(GraviteeContext.getExecutionContext(), this.api, closePlans);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="deploy")
    @Operation(summary="Deploy API to gateway instances", description="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully deployed", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deployApi(@Parameter(name="apiDeployment") @Valid ApiDeploymentEntity apiDeploymentEntity) {
        try {
            ApiEntity apiEntity = this.apiService.deploy(GraviteeContext.getExecutionContext(), this.api, this.getAuthenticatedUser(), EventType.PUBLISH_API, apiDeploymentEntity);
            return Response.ok((Object)apiEntity).tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("JsonProcessingException " + e)).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_debug")
    @Operation(summary="Debug an API on gateway instances", description="User must have the UPDATE permission on API_DEFINITION to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Debug session successfully started", content={@Content(mediaType="application/json", schema=@Schema(implementation=EventEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    @GraviteeLicenseFeature(value="apim-debug-mode")
    public Response debugAPI(@Parameter(name="request") @Valid DebugApiEntity debugApiEntity) {
        return Response.ok((Object)this.debugApiUseCase.execute(DebugApiUseCase.Input.builder().apiId(this.api).debugApi(DebugApiMapper.INSTANCE.fromEntity(debugApiEntity)).auditInfo(this.getAuditInfo()).build()).debugApiEvent()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="state")
    @Operation(summary="Get the state of the API", description="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API's state", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiStateEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public ApiStateEntity isApiSynchronized() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.canReadApi(executionContext, this.api);
        ApiStateEntity apiStateEntity = new ApiStateEntity();
        apiStateEntity.setApiId(this.api);
        this.setSynchronizationState(executionContext, apiStateEntity);
        return apiStateEntity;
    }

    @POST
    @Consumes
    @Produces(value={"application/json"})
    @Path(value="rollback")
    @Operation(summary="Rollback API to a previous version", description="User must have the MANAGE_LIFECYCLE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully rollbacked", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response rollbackApi(@Parameter(name="api", required=true) @Valid @NotNull RollbackApiEntity apiEntity) {
        try {
            ApiEntity rollbackedApi = this.apiService.rollback(GraviteeContext.getExecutionContext(), this.api, apiEntity);
            return Response.ok((Object)rollbackedApi).tag(Long.toString(rollbackedApi.getUpdatedAt().getTime())).lastModified(rollbackedApi.getUpdatedAt()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).build();
        }
    }

    @POST
    @Deprecated
    @Produces(value={"application/json"})
    @Path(value="import")
    @Operation(summary="Deprecated, Update the API with an existing API definition in JSON format either with json or via an URL", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deprecated_updateApiWithDefinition(@RequestBody @Valid @NotNull Object apiDefinitionOrUrl) {
        ApiEntity updatedApi = this.apiDuplicatorService.createWithImportedDefinition(GraviteeContext.getExecutionContext(), apiDefinitionOrUrl);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="import")
    @Operation(summary="Update the API with an existing API definition in JSON format either with json or via an URL", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithDefinition(@RequestBody @Valid @NotNull JsonNode apiDefinition) {
        return this.updateApiWithDefinitionOrUrl(apiDefinition);
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Path(value="import-url")
    @Operation(summary="Update the API with an existing API definition in JSON format either with json or via an URL", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithUrl(@RequestBody @Valid @NotNull String apiDefinitionOrUrl) {
        return this.updateApiWithDefinitionOrUrl(apiDefinitionOrUrl);
    }

    @Deprecated(since="3.18.0", forRemoval=true)
    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @Path(value="import")
    @Operation(summary="Update the API with an existing API definition in JSON format either with json or via an URL", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deprecatedUpdateApiWithUrl(@RequestBody @Valid @NotNull String apiDefinitionOrUrl) {
        return this.updateApiWithDefinitionOrUrl(apiDefinitionOrUrl);
    }

    private Response updateApiWithDefinitionOrUrl(Object apiDefinitionOrUrl) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        ApiEntity updatedApi = this.apiDuplicatorService.updateWithImportedDefinition(GraviteeContext.getExecutionContext(), apiEntity.getId(), apiDefinitionOrUrl);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @POST
    @Deprecated
    @Path(value="import/swagger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Deprecated, use PUT method instead. Update the API with an existing Swagger descriptor", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from Swagger descriptor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response deprecated_updateApiWithSwagger(@Parameter(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(executionContext, swaggerDescriptor);
        ApiEntity updatedApi = this.apiService.updateFromSwagger(executionContext, this.api, swaggerApiEntity, swaggerDescriptor);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @PUT
    @Path(value="import/swagger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update the API with an existing Swagger descriptor", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated from Swagger descriptor", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiWithSwaggerPUT(@Parameter(name="swagger", required=true) @Valid @NotNull ImportSwaggerDescriptorEntity swaggerDescriptor, @QueryParam(value="definitionVersion") @DefaultValue(value="1.0.0") String definitionVersion) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(executionContext, swaggerDescriptor, DefinitionVersion.valueOfLabel((String)definitionVersion));
        ApiEntity updatedApi = this.apiService.updateFromSwagger(executionContext, this.api, swaggerApiEntity, swaggerDescriptor);
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="export")
    @Operation(summary="Export the API definition in JSON format", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ})})
    public Response exportApiDefinition(@QueryParam(value="version") @DefaultValue(value="default") String version, @QueryParam(value="exclude") @DefaultValue(value="") String exclude) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        String apiDefinition = this.apiExportService.exportAsJson(executionContext, this.api, version, exclude.split(","));
        return Response.ok((Object)apiDefinition).header("Content-Disposition", (Object)String.format("attachment;filename=%s", this.getExportFilename(apiEntity, "json"))).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="crd")
    @Operation(summary="Export the API definition in a GKO CRD format", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/yaml")}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ})})
    public Response exportApiCRD(@Parameter @BeanParam ApiExportParam exportParams) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        ApiExportQuery exportQuery = ApiExportQuery.builder().removeIds(exportParams.isRemoveIds()).contextPath(exportParams.getContextPath()).version(exportParams.getVersion()).contextRefName(exportParams.getManagementContextName()).contextRefNamespace(exportParams.getManagementContextNamespace()).exclude(exportParams.getExclude()).build();
        String apiDefinition = this.apiExportService.exportAsCustomResourceDefinition(executionContext, apiEntity.getId(), exportQuery);
        return Response.ok((Object)apiDefinition).header("Content-Disposition", (Object)String.format("attachment;filename=%s", this.getExportFilename(apiEntity, "yml"))).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="notifiers")
    @Operation(summary="List available notifiers for API", description="User must have the API_NOTIFICATION[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_NOTIFICATION, acls={RolePermissionAction.READ})})
    public List<NotifierEntity> getApiNotifiers() {
        return this.notifierService.list(NotificationReferenceType.API, this.api);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="import-path-mappings")
    @Operation(summary="Import path mappings from a page", description="User must have the MANAGE_API permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Path mappings successfully imported", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response importApiPathMappingsFromPage(@QueryParam(value="page") @NotNull String page, @QueryParam(value="definitionVersion") @DefaultValue(value="1.0.0") String definitionVersion) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        ApiEntity updatedApi = this.apiService.importPathMappingsFromPage(GraviteeContext.getExecutionContext(), apiEntity, page, DefinitionVersion.valueOfLabel((String)definitionVersion));
        return Response.ok((Object)updatedApi).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="quality")
    @Operation(summary="Get the quality metrics of the API")
    public ApiQualityMetricsEntity getApiQualityMetrics() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        this.canReadApi(executionContext, this.api);
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        return this.qualityMetricsService.getMetrics(executionContext, apiEntity);
    }

    @POST
    @Path(value="/messages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Send a message to existing consumers of an API", description="User must have the API_MESSAGE[CREATE] permission to use this service")
    @ApiResponse(responseCode="200", description="Message successfully sent, the resulting integer is the number of recipients that were found", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))})
    @Permissions(value={@Permission(value=RolePermission.API_MESSAGE, acls={RolePermissionAction.CREATE})})
    public Response createApiMessage(MessageEntity message) {
        return Response.ok((Object)this.messageService.create(GraviteeContext.getExecutionContext(), this.api, message)).build();
    }

    @GET
    @Path(value="headers")
    @Operation(summary="Get the portal API headers values")
    @Produces(value={"application/json"})
    public List<ApiHeaderEntity> getPortalApiHeaders() {
        return this.apiService.getPortalHeaders(GraviteeContext.getExecutionContext(), this.api);
    }

    @POST
    @Path(value="reviews")
    @Operation(summary="Manage the API's review state", description="User must have the API_DEFINITION[UPDATE] or API_REVIEWS[UPDATE] permission to use this service (depending on the action)")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Updated API"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.API_REVIEWS, acls={RolePermissionAction.UPDATE})})
    public Response doApiReviewAction(@Context HttpHeaders headers, @Parameter(required=true) @NotNull @Valid @QueryParam(value="action") ReviewAction action, @Parameter(name="review") @Valid ReviewEntity reviewEntity) {
        Response responseApi = this.getApi();
        Response.ResponseBuilder builder = this.evaluateIfMatch(headers, responseApi.getEntityTag().getValue());
        if (builder != null) {
            return builder.build();
        }
        ApiEntity apiEntity = (ApiEntity)responseApi.getEntity();
        ApiEntity updatedApi = null;
        this.checkApiReviewWorkflow(apiEntity, action);
        switch (action) {
            case ASK: {
                this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DEFINITION, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.askForReview(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
                break;
            }
            case ACCEPT: {
                this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_REVIEWS, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.acceptReview(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
                break;
            }
            case REJECT: {
                this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_REVIEWS, this.api, RolePermissionAction.UPDATE);
                updatedApi = this.apiService.rejectReview(GraviteeContext.getExecutionContext(), apiEntity.getId(), this.getAuthenticatedUser(), reviewEntity);
            }
        }
        return Response.noContent().tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
    }

    private void checkApiReviewWorkflow(ApiEntity api, ReviewAction action) {
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException("Deleted API cannot be reviewed");
        }
        if (api.getWorkflowState() != null) {
            switch (api.getWorkflowState()) {
                case IN_REVIEW: {
                    if (!ReviewAction.ASK.equals((Object)action)) break;
                    throw new BadRequestException("Review is still in progress");
                }
                case DRAFT: {
                    if (!ReviewAction.ACCEPT.equals((Object)action) && !ReviewAction.REJECT.equals((Object)action)) break;
                    throw new BadRequestException("State invalid to accept/reject a review");
                }
            }
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="duplicate")
    @Operation(summary="Duplicate the API", description="User must have the MANAGE_API create permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response duplicateAPI(@Parameter(name="api", required=true) @Valid @NotNull DuplicateApiEntity duplicateApiEntity) {
        ApiEntity apiEntity = (ApiEntity)this.getApi().getEntity();
        return Response.ok((Object)this.apiDuplicatorService.duplicate(GraviteeContext.getExecutionContext(), apiEntity, duplicateApiEntity)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_migrate")
    @Operation(summary="Migrate the API definition to be used with Policy Studio", description="User must have the MANAGE_API create permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.CREATE})})
    public Response migrateAPI() {
        return Response.ok((Object)this.apiService.migrate(GraviteeContext.getExecutionContext(), this.api)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="_promote")
    @Operation(summary="Promote the API to another environment", description="User must have the API_DEFINITION update permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Promotion request", content={@Content(mediaType="application/json", schema=@Schema(implementation=PromotionEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response promoteAPI(@RequestBody @Valid @NotNull PromotionRequestEntity promotionRequest) throws TechnicalException {
        PromotionEntity promotion = this.promotionService.create(GraviteeContext.getExecutionContext(), GraviteeContext.getCurrentEnvironment(), this.api, promotionRequest, this.getAuthenticatedUser());
        return Response.ok((Object)this.promotionService.promote(GraviteeContext.getExecutionContext(), promotion.getId())).build();
    }

    @Path(value="members")
    public ApiMembersResource getApiMembersResource() {
        return (ApiMembersResource)this.resourceContext.getResource(ApiMembersResource.class);
    }

    @Path(value="groups")
    public ApiGroupsResource getApiGroupsResource() {
        return (ApiGroupsResource)this.resourceContext.getResource(ApiGroupsResource.class);
    }

    @Path(value="analytics")
    public ApiAnalyticsResource getApiAnalyticsResource() {
        return (ApiAnalyticsResource)this.resourceContext.getResource(ApiAnalyticsResource.class);
    }

    @Path(value="logs")
    public ApiLogsResource getApiLogsResource() {
        return (ApiLogsResource)this.resourceContext.getResource(ApiLogsResource.class);
    }

    @Path(value="health")
    public ApiHealthResource getApiHealthResource() {
        return (ApiHealthResource)this.resourceContext.getResource(ApiHealthResource.class);
    }

    @Path(value="pages")
    public ApiPagesResource getApiPagesResource() {
        return (ApiPagesResource)this.resourceContext.getResource(ApiPagesResource.class);
    }

    @Path(value="events")
    public ApiEventsResource getApiEventsResource() {
        return (ApiEventsResource)this.resourceContext.getResource(ApiEventsResource.class);
    }

    @Path(value="plans")
    public ApiPlansResource getApiPlansResource() {
        return (ApiPlansResource)this.resourceContext.getResource(ApiPlansResource.class);
    }

    @Path(value="subscriptions")
    public ApiSubscriptionsResource getApiSubscriptionsResource() {
        return (ApiSubscriptionsResource)this.resourceContext.getResource(ApiSubscriptionsResource.class);
    }

    @Path(value="subscribers")
    public ApiSubscribersResource geApiSubscribersResource() {
        return (ApiSubscribersResource)this.resourceContext.getResource(ApiSubscribersResource.class);
    }

    @Path(value="metadata")
    public ApiMetadataResource getApiMetadataResource() {
        return (ApiMetadataResource)this.resourceContext.getResource(ApiMetadataResource.class);
    }

    @Path(value="ratings")
    public ApiRatingResource getRatingResource() {
        return (ApiRatingResource)this.resourceContext.getResource(ApiRatingResource.class);
    }

    @Path(value="audit")
    public ApiAuditResource getApiAuditResource() {
        return (ApiAuditResource)this.resourceContext.getResource(ApiAuditResource.class);
    }

    @Path(value="notificationsettings")
    public ApiNotificationSettingsResource getNotificationSettingsResource() {
        return (ApiNotificationSettingsResource)this.resourceContext.getResource(ApiNotificationSettingsResource.class);
    }

    @Path(value="alerts")
    public ApiAlertsResource getApiAlertsResource() {
        return (ApiAlertsResource)this.resourceContext.getResource(ApiAlertsResource.class);
    }

    @Path(value="quality-rules")
    public ApiQualityRulesResource getApiQualityRulesResource() {
        return (ApiQualityRulesResource)this.resourceContext.getResource(ApiQualityRulesResource.class);
    }

    @Path(value="definition")
    public ApiDefinitionResource getApiDefinition() {
        return (ApiDefinitionResource)this.resourceContext.getResource(ApiDefinitionResource.class);
    }

    @Path(value="definition-context")
    public ApiDefinitionContextResource getApiDefinitionContextResource() {
        return (ApiDefinitionContextResource)this.resourceContext.getResource(ApiDefinitionContextResource.class);
    }

    private void setSynchronizationState(ExecutionContext executionContext, ApiStateEntity apiStateEntity) {
        apiStateEntity.setIsSynchronized(this.apiService.isSynchronized(executionContext, apiStateEntity.getApiId()));
    }

    private void checkApiLifeCycle(ApiEntity api, LifecycleAction action) {
        if (ApiLifecycleState.ARCHIVED.equals((Object)api.getLifecycleState())) {
            throw new BadRequestException("Deleted API cannot be " + action.name().toLowerCase());
        }
        switch (api.getState()) {
            case STARTED: {
                if (api.getDefinitionContext().isOriginKubernetes() || !LifecycleAction.START.equals((Object)action)) break;
                throw new BadRequestException("API is already started");
            }
            case STOPPED: {
                if (!api.getDefinitionContext().isOriginKubernetes() && LifecycleAction.STOP.equals((Object)action)) {
                    throw new BadRequestException("API is already stopped");
                }
                boolean apiReviewEnabled = this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT);
                if (!apiReviewEnabled || api.getWorkflowState() == null || WorkflowState.REVIEW_OK.equals((Object)api.getWorkflowState())) break;
                throw new BadRequestException("API cannot be started without being reviewed");
            }
        }
    }

    private String getExportFilename(ApiEntity apiEntity, String extension) {
        return String.format("%s-%s.%s", apiEntity.getName(), apiEntity.getVersion(), extension).trim().toLowerCase().replaceAll(" +", " ").replaceAll(" ", "-").replaceAll("[^\\w\\s\\.]", "-").replaceAll("-+", "-");
    }

    private void filterSensitiveData(ApiEntity entity) {
        Proxy filteredProxy = new Proxy();
        VirtualHost virtualHost = (VirtualHost)entity.getProxy().getVirtualHosts().get(0);
        virtualHost.setHost(null);
        filteredProxy.setVirtualHosts(Collections.singletonList(virtualHost));
        entity.setProxy(filteredProxy);
        entity.setPaths(null);
        entity.setProperties(null);
        entity.setServices(null);
        entity.setResources(null);
        entity.setPathMappings(null);
        entity.setResponseTemplates(null);
    }
}

