/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;

public class PagedResult<T> {
    private Collection<T> data;
    private Map<String, Map<String, Object>> metadata;
    private Page page;

    public PagedResult(Collection<T> data, int pageNumber, int perPage, int totalElements) {
        this.data = data;
        this.page = new Page(pageNumber, perPage, data.size(), totalElements);
    }

    public PagedResult(Collection<T> data) {
        this(data, 1, data.size(), data.size());
    }

    public PagedResult(io.gravitee.common.data.domain.Page<T> page, int perPage) {
        this(page.getContent(), page.getPageNumber(), perPage, (int)page.getTotalElements());
    }

    public PagedResult() {
    }

    public Collection<T> getData() {
        return this.data;
    }

    public void setMetadata(Map<String, Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Map<String, Object>> getMetadata() {
        return this.metadata;
    }

    public Page getPage() {
        return this.page;
    }

    public static class Page {
        private int current;
        @JsonProperty(value="per_page")
        private int perPage;
        private int size;
        @JsonProperty(value="total_pages")
        private int totalPages;
        @JsonProperty(value="total_elements")
        private int totalElements;

        public Page() {
        }

        public Page(int current, int perPage, int size, int totalElements) {
            this.current = current;
            this.perPage = perPage;
            this.size = size;
            this.totalPages = (int)Math.ceil((double)totalElements / (double)perPage);
            this.totalElements = totalElements;
        }

        public int getCurrent() {
            return this.current;
        }

        public int getPerPage() {
            return this.perPage;
        }

        public int getSize() {
            return this.size;
        }

        public int getTotalPages() {
            return this.totalPages;
        }

        public int getTotalElements() {
            return this.totalElements;
        }
    }
}

