/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.RegisterUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="User Registration")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UsersRegistrationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;

    @POST
    @Operation(summary="Register a user", description="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully registered", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response registerUser(@Valid NewExternalUserEntity newExternalUserEntity) {
        UserEntity newUser = this.userService.register(GraviteeContext.getExecutionContext(), newExternalUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/finalize")
    @Operation(summary="Finalize user registration", description="User registration must be enabled")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response finalizeUserRegistration(@Valid RegisterUserEntity registerUserEntity) {
        UserEntity newUser = this.userService.finalizeRegistration(GraviteeContext.getExecutionContext(), registerUserEntity);
        if (newUser != null) {
            return Response.ok().entity((Object)newUser).build();
        }
        return Response.serverError().build();
    }
}

