/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.identity;

import io.gravitee.rest.api.management.rest.model.configuration.identity.IdentityProviderListItem;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.configuration.identity.IdentityProviderResource;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderType;
import io.gravitee.rest.api.model.configuration.identity.NewIdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.gravitee.rest.api.service.exceptions.ForbiddenFeatureException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@Tags(value={@Tag(name="Configuration"), @Tag(name="Identity Providers")})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IdentityProvidersResource
extends AbstractResource {
    @Autowired
    private IdentityProviderService identityProviderService;
    @Context
    private ResourceContext resourceContext;

    @GET
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.READ})})
    @Operation(summary="Get the list of identity providers", description="User must have the ORGANIZATION_IDENTITY_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List identity providers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=IdentityProviderListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<IdentityProviderListItem> getIdentityProviders() {
        return this.identityProviderService.findAll(GraviteeContext.getExecutionContext()).stream().map(identityProvider -> {
            IdentityProviderListItem item = new IdentityProviderListItem();
            item.setId(identityProvider.getId());
            item.setName(identityProvider.getName());
            item.setDescription(identityProvider.getDescription());
            item.setEnabled(identityProvider.isEnabled());
            item.setType(identityProvider.getType());
            item.setCreatedAt(identityProvider.getCreatedAt());
            item.setUpdatedAt(identityProvider.getUpdatedAt());
            item.setSync(identityProvider.isSyncMappings());
            return item;
        }).collect(Collectors.toList());
    }

    @POST
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.CREATE})})
    @Operation(summary="Create an identity provider", description="User must have the ORGANIZATION_IDENTITY_PROVIDER[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Identity provider successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentityProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createIdentityProvider(@Parameter(name="identity-provider", required=true) @Valid @NotNull NewIdentityProviderEntity newIdentityProviderEntity) {
        this.checkOpenIdConnectProviderLicense(newIdentityProviderEntity);
        IdentityProviderEntity newIdentityProvider = this.identityProviderService.create(GraviteeContext.getExecutionContext(), newIdentityProviderEntity);
        if (newIdentityProvider != null) {
            return Response.created((URI)this.getLocationHeader(newIdentityProvider.getId())).entity((Object)newIdentityProvider).build();
        }
        return Response.serverError().build();
    }

    @Path(value="{identityProvider}")
    public IdentityProviderResource getIdentityProviderResource() {
        return (IdentityProviderResource)this.resourceContext.getResource(IdentityProviderResource.class);
    }

    private void checkOpenIdConnectProviderLicense(NewIdentityProviderEntity newIdentityProviderEntity) {
        String featureName = "apim-openid-connect-sso";
        if (this.isFeatureEnabled(featureName)) {
            return;
        }
        if (IdentityProviderType.OIDC.equals((Object)newIdentityProviderEntity.getType())) {
            throw new ForbiddenFeatureException(featureName);
        }
    }
}

