/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.resource.auth.AbstractAuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.AbstractKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.Algorithm;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.HMACKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.JWKSKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.RSAECKeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidAlgorithmException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidTokenException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.ECJWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.MACJWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.RSAJWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.RemoteJWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.resolver.PublicKeyResolver;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Singleton
@Path(value="/auth/external")
public class ExternalAuthenticationResource
extends AbstractAuthenticationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalAuthenticationResource.class);
    protected static final String ORG_CLAIM = "org";
    protected static final String ENVIRONMENT_CLAIM = "env";
    private boolean enabled;
    private Algorithm algorithm;
    private AbstractKeyProcessor<?> keyProcessor;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;

    @PostConstruct
    public void afterPropertiesSet() {
        this.enabled = (Boolean)this.environment.getProperty("auth.external.enabled", Boolean.class, (Object)false);
        if (this.enabled) {
            try {
                this.algorithm = (Algorithm)((Object)this.environment.getProperty("auth.external.algorithm", Algorithm.class));
                if (this.algorithm == null) {
                    throw new InvalidAlgorithmException("Algorithm can not be null, it can be set using auth.external.algorithm in the gravitee config file");
                }
                PublicKeyResolver publicKeyResolver = () -> this.environment.getProperty("auth.external.verificationKey");
                if (publicKeyResolver.resolve() == null) {
                    throw new IllegalArgumentException("The Authentication key can not be null. You can either set a ULR to you existing JWKS or pass the public key directly");
                }
                String issuer = (String)this.environment.getProperty("auth.external.issuer", String.class);
                JWTClaimsSet claimsSet = null;
                if (issuer != null) {
                    claimsSet = new JWTClaimsSet.Builder().issuer(issuer).build();
                }
                DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier(claimsSet, new HashSet<String>(Arrays.asList("sub", "iss", "iat")));
                if (publicKeyResolver.resolve().toLowerCase().startsWith("http")) {
                    this.keyProcessor = new JWKSKeyProcessor(claimsVerifier);
                    this.keyProcessor.setJwkSourceResolver(new RemoteJWKSourceResolver(publicKeyResolver));
                } else {
                    switch (this.algorithm) {
                        case RS256: 
                        case RS384: 
                        case RS512: {
                            this.keyProcessor = new RSAECKeyProcessor(claimsVerifier);
                            this.keyProcessor.setJwkSourceResolver(new RSAJWKSourceResolver(publicKeyResolver));
                            break;
                        }
                        case HS256: 
                        case HS384: 
                        case HS512: {
                            this.keyProcessor = new HMACKeyProcessor(claimsVerifier);
                            this.keyProcessor.setJwkSourceResolver(new MACJWKSourceResolver(publicKeyResolver));
                            break;
                        }
                        case ES256: 
                        case ES384: 
                        case ES512: {
                            this.keyProcessor = new RSAECKeyProcessor(claimsVerifier);
                            this.keyProcessor.setJwkSourceResolver(new ECJWKSourceResolver(publicKeyResolver));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize external authentication resource", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response tokenExchange(@QueryParam(value="token") String token, @Context HttpServletResponse httpResponse) {
        Response response;
        if (!this.enabled) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            JWTClaimsSet jwtClaimsSet = this.keyProcessor.process(this.algorithm, token);
            String organizationId = jwtClaimsSet.getStringClaim(ORG_CLAIM);
            if (organizationId == null) {
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response2;
            }
            String environmentId = jwtClaimsSet.getStringClaim(ENVIRONMENT_CLAIM);
            if (environmentId == null) {
                Response response3 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response3;
            }
            GraviteeContext.fromExecutionContext((ExecutionContext)new ExecutionContext(organizationId, environmentId));
            UserEntity user = this.userService.findBySource(GraviteeContext.getCurrentOrganization(), jwtClaimsSet.getIssuer(), jwtClaimsSet.getSubject(), true);
            Set authorities = this.authoritiesProvider.retrieveAuthorities(user.getId(), organizationId, environmentId);
            UserDetails userDetails = new UserDetails(user.getId(), "", (Collection)authorities);
            userDetails.setEmail(user.getEmail());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, (Collection)authorities));
            super.connectUser(user, httpResponse);
            String url = String.format("%s/#!/environments/%s", this.installationAccessQueryService.getConsoleUrl(organizationId), environmentId);
            Response response4 = Response.temporaryRedirect((URI)new URI(url)).build();
            return response4;
        }
        catch (InvalidTokenException | UserNotFoundException e) {
            LOGGER.error("Authentication failed", e);
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when trying to log user using external authentication provider.", (Throwable)e);
            response = Response.serverError().build();
            return response;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }
}

