/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.api_key.use_case.RevokeApiSubscriptionApiKeyUseCase;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.resource.AbstractApiKeyResource;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="API Keys")
public class ApiSubscriptionApiKeyResource
extends AbstractApiKeyResource {
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private RevokeApiSubscriptionApiKeyUseCase revokeApiSubscriptionApiKeyUsecase;
    @Inject
    private SubscriptionService subscriptionService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;
    @PathParam(value="subscription")
    @Parameter(name="subscription", hidden=true)
    private String subscription;
    @PathParam(value="apikey")
    @Parameter(name="apikey")
    private String apikey;

    @POST
    @Path(value="/_reactivate")
    @Produces(value={"application/json"})
    @Operation(summary="Reactivate an API Key", description="User must have the API_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="API Key successfully reactivated"), @ApiResponse(responseCode="400", description="API Key does not correspond to the subscription"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response reactivateApiKeyForApiSubscription() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiKeyEntity apiKeyEntity = this.apiKeyService.findById(executionContext, this.apikey);
        if (!apiKeyEntity.hasSubscription(this.subscription)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"API Key in path does not correspond to the subscription").build();
        }
        this.checkApplicationDoesntUseSharedApiKey(apiKeyEntity.getApplication());
        ApiKeyEntity reactivated = this.apiKeyService.reactivate(executionContext, apiKeyEntity);
        return Response.ok().entity((Object)reactivated).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Revoke API Key", description="User must have the API_SUBSCRIPTION:DELETE permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApiSubscription() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        UserDetails user = this.getAuthenticatedUserDetails();
        this.revokeApiSubscriptionApiKeyUsecase.execute(new RevokeApiSubscriptionApiKeyUseCase.Input(this.apikey, this.api, this.subscription, AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(user.getUsername()).userSource(user.getSource()).userSourceId(user.getSourceId()).build()).build()));
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update API Key", description="User must have the API_SUBSCRIPTION:UPDATE permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API Key successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiKeyEntity.class))}), @ApiResponse(responseCode="400", description="Bad API Key key format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiKeyForApiSubscription(@Valid @NotNull ApiKeyEntity apiKey) {
        if (!this.apikey.equals(apiKey.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'apikey' parameter in path does not correspond to the api-key id to update").build();
        }
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        if (subscriptionEntity == null) {
            throw new SubscriptionNotFoundException(this.subscription);
        }
        this.checkApplicationDoesntUseSharedApiKey(executionContext, subscriptionEntity.getApplication());
        ApiKeyEntity updatedKeyEntity = this.apiKeyService.update(executionContext, apiKey);
        return Response.ok((Object)updatedKeyEntity).build();
    }
}

