/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.Algorithm;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.KeyProcessor;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidTokenException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.JWKSourceResolver;

public abstract class AbstractKeyProcessor<C extends SecurityContext>
implements KeyProcessor {
    private JWKSourceResolver<C> jwkSourceResolver;
    protected final DefaultJWTClaimsVerifier<C> claimsVerifier;

    protected AbstractKeyProcessor(DefaultJWTClaimsVerifier<C> claimsVerifier) {
        this.claimsVerifier = claimsVerifier;
    }

    @Override
    public JWTClaimsSet process(Algorithm algorithm, String token) {
        JWKSource<C> jwkSource = this.jwkSourceResolver.resolve();
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetVerifier(this.claimsVerifier);
        jwtProcessor.setJWSKeySelector(this.jwsKeySelector(jwkSource, algorithm));
        try {
            return jwtProcessor.process(token, null);
        }
        catch (Exception ex) {
            throw new InvalidTokenException(ex);
        }
    }

    public void setJwkSourceResolver(JWKSourceResolver<C> jwkSourceResolver) {
        this.jwkSourceResolver = jwkSourceResolver;
    }

    abstract JWSKeySelector<C> jwsKeySelector(JWKSource<C> var1, Algorithm var2);
}

