/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.management.rest.model.RestrictedDomain;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import java.util.Collection;

@Tag(name="Restricted Domains")
public class RestrictedDomainsResource {
    @Inject
    private InstallationAccessQueryService installationAccessQueryService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the restricted domain")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Restricted domains for the environment", content={@Content(mediaType="application/json", schema=@Schema(implementation=io.gravitee.apim.core.installation.model.RestrictedDomain.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<RestrictedDomain> getRestrictedDomains() {
        return this.installationAccessQueryService.getGatewayRestrictedDomains(GraviteeContext.getCurrentEnvironment()).stream().map(restrictedDomainEntity -> new RestrictedDomain(restrictedDomainEntity.getDomain(), restrictedDomainEntity.isSecured())).toList();
    }
}

