/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.api_key.use_case.RevokeApplicationSubscriptionApiKeyUseCase;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.resource.AbstractApiKeyResource;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="API Keys")
public class ApplicationSubscriptionApiKeyResource
extends AbstractApiKeyResource {
    @Inject
    private RevokeApplicationSubscriptionApiKeyUseCase revokeApplicationSubscriptionApiKeyUsecase;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;
    @PathParam(value="subscription")
    @Parameter(name="subscription", hidden=true)
    private String subscription;
    @PathParam(value="apikey")
    @Parameter(name="apikey")
    private String apikey;

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Revoke an API Key", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="API Key successfully revoked"), @ApiResponse(responseCode="400", description="API Key does not correspond to the subscription"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.DELETE})})
    public Response revokeApiKeyForApplicationSubscription() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        UserDetails user = this.getAuthenticatedUserDetails();
        this.revokeApplicationSubscriptionApiKeyUsecase.execute(new RevokeApplicationSubscriptionApiKeyUseCase.Input(this.apikey, this.application, this.subscription, AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(user.getUsername()).userSource(user.getSource()).userSourceId(user.getSourceId()).build()).build()));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

