/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.param;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

public abstract class AbstractParam<V> {
    private final V value;
    private final String originalParam;

    public AbstractParam(String param) throws WebApplicationException {
        this.originalParam = param;
        try {
            this.value = this.parse(param);
        }
        catch (Throwable e) {
            throw new WebApplicationException(this.onError(param, e));
        }
    }

    public V getValue() {
        return this.value;
    }

    public String getOriginalParam() {
        return this.originalParam;
    }

    public String toString() {
        return this.value.toString();
    }

    protected abstract V parse(String var1) throws Throwable;

    protected Response onError(String param, Throwable e) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorMessage(param, e)).build();
    }

    protected String getErrorMessage(String param, Throwable e) {
        return "Invalid parameter: " + param + " (" + e.getMessage() + ")";
    }
}

