/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.InstallationStatus;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.InstallationNotAcceptedException;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Tag(name="Promotion")
public class PromotionTargetsResource
extends AbstractResource {
    @Inject
    private PromotionService promotionService;
    @Inject
    private InstallationService installationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List available targets (environments) for a promotion")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of promotion targets", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PromotionTargetEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="503", description="Installation not connected to cockpit")})
    public Response getPromotionTargets() {
        InstallationStatus status = this.installationService.getInstallationStatus();
        if (InstallationStatus.ACCEPTED == status) {
            List promotionTargetEntities = this.promotionService.listPromotionTargets(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment());
            return Response.ok((Object)promotionTargetEntities).build();
        }
        throw new InstallationNotAcceptedException(this.installationService.get(), status);
    }
}

