/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractCategoryResource;
import io.gravitee.rest.api.management.rest.resource.CategoryResource;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.NewCategoryEntity;
import io.gravitee.rest.api.model.UpdateCategoryEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="Categories")
public class CategoriesResource
extends AbstractCategoryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private CategoryService categoryService;
    private static final String INCLUDE_TOTAL_APIS = "total-apis";

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve list of categories")
    public List<CategoryEntity> getCategories(@QueryParam(value="include") List<String> include) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        boolean hasAllPermissions = this.hasPermission(executionContext, RolePermission.ENVIRONMENT_CATEGORY, RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE);
        return this.categoryService.findAll(GraviteeContext.getCurrentEnvironment()).stream().filter(c -> hasAllPermissions || !c.isHidden()).sorted(Comparator.comparingInt(CategoryEntity::getOrder)).map(c -> this.setPictures((CategoryEntity)c, true)).map(categoryEntity -> {
            if (include.contains(INCLUDE_TOTAL_APIS)) {
                categoryEntity.setTotalApis(this.apiService.countByCategoryForUser(executionContext, categoryEntity.getId(), this.getAuthenticatedUser()));
            }
            return categoryEntity;
        }).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a category", description="User must have the PORTAL_CATEGORY[CREATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.CREATE})})
    public CategoryEntity createCategory(@Valid @NotNull NewCategoryEntity category) {
        try {
            ImageUtils.verify((String)category.getPicture());
            ImageUtils.verify((String)category.getBackground());
        }
        catch (InvalidImageException e) {
            throw new BadRequestException("Invalid image format : " + e.getMessage());
        }
        return this.categoryService.create(GraviteeContext.getExecutionContext(), category);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing category", description="User must have the PORTAL_CATEGORY[UPDATE] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_CATEGORY, acls={RolePermissionAction.UPDATE})})
    public List<CategoryEntity> updateCategories(@Valid @NotNull List<UpdateCategoryEntity> categories) {
        return this.categoryService.update(GraviteeContext.getExecutionContext(), categories);
    }

    @Path(value="{categoryId}")
    public CategoryResource getCategoryResource() {
        return (CategoryResource)this.resourceContext.getResource(CategoryResource.class);
    }
}

