/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.param.AbstractParam;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import java.util.Arrays;

public class ApisOrderParam
extends AbstractParam<ApisOrder> {
    public ApisOrderParam(String param) {
        super(param);
    }

    @Override
    protected ApisOrder parse(String param) {
        if (param != null) {
            return ApisOrder.forValue(param.toLowerCase());
        }
        return null;
    }

    protected Sortable toSortable() {
        ApisOrder order = (ApisOrder)((Object)this.getValue());
        if (order != null) {
            return new SortableImpl(order.field, order.isAsc);
        }
        return null;
    }

    public static enum ApisOrder {
        NAME("name", true),
        NAME_DESC("name", false),
        PATHS("paths", true),
        PATHS_DESC("paths", false);

        public final String field;
        public final boolean isAsc;

        public static ApisOrder forValue(String order) {
            boolean isAsc = !order.startsWith("-");
            String field = order.replace("-", "");
            return Arrays.stream(ApisOrder.values()).filter(o -> o.field.equalsIgnoreCase(field) && o.isAsc == isAsc).findFirst().orElse(null);
        }

        private ApisOrder(String field, boolean isAsc) {
            this.field = field;
            this.isAsc = isAsc;
        }

        public String toString() {
            return this.isAsc ? this.field : "-" + this.field;
        }
    }
}

