/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiPageMediaResource;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PageMarkdownTemplateActionException;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@Tag(name="API Pages")
public class ApiPageResource
extends AbstractResource {
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;
    @PathParam(value="page")
    @Parameter(name="page", required=true)
    private String page;
    @Context
    private ResourceContext resourceContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a page", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public PageEntity getApiPage(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="portal") boolean portal, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.api);
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility()) || this.hasPermission(executionContext, RolePermission.API_DOCUMENTATION, this.api, RolePermissionAction.READ)) {
            PageEntity pageEntity = this.pageService.findById(this.page, translated ? acceptedLocale : null);
            pageEntity.setGeneralConditions(this.pageService.isPageUsedAsGeneralConditions(executionContext, pageEntity, this.api));
            if (portal) {
                this.pageService.transformSwagger(executionContext, pageEntity, genericApiEntity);
                if (!this.isAuthenticated() && pageEntity.getMetadata() != null) {
                    pageEntity.getMetadata().clear();
                }
            }
            if (this.isDisplayable(genericApiEntity, pageEntity)) {
                if (pageEntity.getContentType() != null) {
                    String content = pageEntity.getContent();
                    try {
                        this.pageService.validateSafeContent(executionContext, pageEntity, this.api);
                    }
                    catch (SwaggerDescriptorException contentException) {
                        pageEntity.setMessages(Collections.singletonList(contentException.getMessage()));
                    }
                    finally {
                        pageEntity.setContent(content);
                    }
                }
                return pageEntity;
            }
            throw new UnauthorizedAccessException();
        }
        throw new ForbiddenAccessException();
    }

    @GET
    @Path(value="/content")
    @Operation(summary="Get the page's content", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page's content", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiPageContent() {
        PageEntity pageEntity = this.getApiPage(null, true, false);
        return Response.ok((Object)pageEntity.getContent(), (String)pageEntity.getContentType()).build();
    }

    @PUT
    @Path(value="/content")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Put the page's content", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page content successfully updated"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public String updatePageContent(@Parameter(name="content", required=true) @Valid @NotNull String content) {
        this.pageService.findById(this.page);
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setContent(content);
        PageEntity update = this.pageService.update(GraviteeContext.getExecutionContext(), this.page, updatePageEntity, true);
        return update.getContent();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a page", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity updateApiPage(@Parameter(name="page", required=true) @Valid @NotNull UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(GraviteeContext.getExecutionContext(), this.page, updatePageEntity);
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @Operation(summary="Refresh page by calling the associated fetcher", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully refreshed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity fetchApiPage() {
        this.pageService.findById(this.page);
        String contributor = this.getAuthenticatedUser();
        return this.pageService.fetch(GraviteeContext.getExecutionContext(), this.page, contributor);
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a page", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public PageEntity partialUpdateApiPage(@Parameter(name="page") UpdatePageEntity updatePageEntity) {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Update");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Update");
        }
        updatePageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.update(GraviteeContext.getExecutionContext(), this.page, updatePageEntity, true);
    }

    @DELETE
    @Operation(summary="Delete a page", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Page successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.DELETE})})
    public void deleteApiPage() {
        PageEntity existingPage = this.pageService.findById(this.page);
        if (existingPage.getType().equals(PageType.SYSTEM_FOLDER.name())) {
            throw new PageSystemFolderActionException("Delete");
        }
        if (existingPage.getType().equals(PageType.MARKDOWN_TEMPLATE.name())) {
            throw new PageMarkdownTemplateActionException("Delete");
        }
        this.pageService.delete(GraviteeContext.getExecutionContext(), this.page);
    }

    private boolean isDisplayable(GenericApiEntity genericApiEntity, PageEntity pageEntity) {
        return this.isAuthenticated() && this.isAdmin() || this.accessControlService.canAccessPageFromConsole(GraviteeContext.getExecutionContext(), genericApiEntity, pageEntity);
    }

    @Path(value="media")
    public ApiPageMediaResource getApiPageMediaResource() {
        return (ApiPageMediaResource)this.resourceContext.getResource(ApiPageMediaResource.class);
    }
}

