/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.exceptions.InvalidKeyException;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.jwks.JWKSourceResolver;
import io.gravitee.rest.api.management.rest.resource.auth.jwt.resolver.PublicKeyResolver;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECJWKSourceResolver<C extends SecurityContext>
implements JWKSourceResolver<C> {
    private final JWK jwk;
    private static final Logger LOGGER = LoggerFactory.getLogger(ECJWKSourceResolver.class);

    private ECJWKSourceResolver(String publicKey) {
        if (publicKey == null) {
            throw new InvalidKeyException("Public key can't be null");
        }
        ECPublicKey ecPublicKey = null;
        try {
            JWK key = JWK.parseFromPEMEncodedObjects((String)publicKey);
            ecPublicKey = ((ECKey)key).toECPublicKey();
        }
        catch (JOSEException e) {
            LOGGER.error("unable to parse public key {}", (Object)e.getMessage());
        }
        this.jwk = ecPublicKey != null ? new ECKey.Builder(Curve.forECParameterSpec((ECParameterSpec)ecPublicKey.getParams()), ecPublicKey).build() : null;
    }

    public ECJWKSourceResolver(PublicKeyResolver publicKeyResolver) {
        this(publicKeyResolver.resolve());
    }

    @Override
    public JWKSource<C> resolve() {
        try {
            return new ImmutableJWKSet(new JWKSet(this.jwk));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

