/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.Aggregation;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsParam;
import io.gravitee.rest.api.management.rest.resource.param.Range;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.HistogramAnalytics;
import io.gravitee.rest.api.model.analytics.HitsAnalytics;
import io.gravitee.rest.api.model.analytics.TopHitsAnalytics;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.CountQuery;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.GroupByQuery;
import io.gravitee.rest.api.model.analytics.query.StatsAnalytics;
import io.gravitee.rest.api.model.analytics.query.StatsQuery;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.application.ApplicationExcludeFilter;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AnalyticsService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Tag(name="Environment Analytics")
public class EnvironmentAnalyticsResource
extends AbstractResource {
    public static final String API_FIELD = "api";
    public static final String APPLICATION_FIELD = "application";
    public static final String STATE_FIELD = "state";
    public static final String LIFECYCLE_STATE_FIELD = "lifecycle_state";
    @Inject
    ApiService apiService;
    @Inject
    io.gravitee.rest.api.service.v4.ApiService apiServiceV4;
    @Inject
    PermissionService permissionService;
    @Inject
    ApplicationService applicationService;
    @Inject
    private AnalyticsService analyticsService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get environment analytics")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Environment analytics", content={@Content(mediaType="application/json", schema=@Schema(implementation=Analytics.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPlatformAnalytics(@BeanParam AnalyticsParam analyticsParam) {
        analyticsParam.validate();
        Analytics analytics = null;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (analyticsParam.getQuery() != null) {
            analyticsParam.setQuery(analyticsParam.getQuery().replaceAll("\\?", "1"));
        }
        switch (analyticsParam.getType()) {
            case DATE_HISTO: {
                analytics = this.executeDateHisto(executionContext, analyticsParam);
                break;
            }
            case GROUP_BY: {
                analytics = this.executeGroupBy(executionContext, analyticsParam);
                break;
            }
            case COUNT: {
                analytics = this.executeCount(executionContext, analyticsParam);
                break;
            }
            case STATS: {
                analytics = this.executeStats(executionContext, analyticsParam);
            }
        }
        return Response.ok(analytics).build();
    }

    private Analytics executeStats(ExecutionContext executionContext, AnalyticsParam analyticsParam) {
        Map<String, Set<String>> terms;
        try {
            terms = this.buildTerms(executionContext, analyticsParam);
        }
        catch (FieldFilterEmptyException e) {
            return new StatsAnalytics();
        }
        StatsQuery query = new StatsQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        query.setTerms(terms);
        return this.analyticsService.execute(query);
    }

    private Analytics executeCount(ExecutionContext executionContext, AnalyticsParam analyticsParam) {
        Map<String, Set<String>> terms;
        switch (analyticsParam.getField()) {
            case "api": {
                return this.buildCountStat(this.apiServiceV4.findAll(executionContext, this.getAuthenticatedUser(), this.isAdmin(), (Pageable)new PageableImpl(1, 1)).getTotalElements());
            }
            case "application": {
                if (this.isAdmin()) {
                    ApplicationQuery applicationQuery = new ApplicationQuery();
                    applicationQuery.setStatus(ApplicationStatus.ACTIVE.name());
                    return this.buildCountStat(this.applicationService.searchIds(executionContext, applicationQuery, null).size());
                }
                return this.buildCountStat(this.applicationService.findIdsByUser(executionContext, this.getAuthenticatedUser()).size());
            }
        }
        try {
            terms = this.buildTerms(executionContext, analyticsParam);
        }
        catch (FieldFilterEmptyException e) {
            return new HitsAnalytics();
        }
        CountQuery query = new CountQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setTerms(terms);
        return this.analyticsService.execute(query);
    }

    private StatsAnalytics buildCountStat(float countValue) {
        StatsAnalytics stats = new StatsAnalytics();
        stats.setCount(Float.valueOf(countValue));
        return stats;
    }

    private Analytics executeDateHisto(ExecutionContext executionContext, AnalyticsParam analyticsParam) {
        Map<String, Set<String>> terms;
        try {
            terms = this.buildTerms(executionContext, analyticsParam);
        }
        catch (FieldFilterEmptyException e) {
            return new HistogramAnalytics();
        }
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        List<Aggregation> aggregations = analyticsParam.getAggregations();
        if (aggregations != null) {
            List aggregationList = aggregations.stream().map(aggregation -> new io.gravitee.rest.api.model.analytics.query.Aggregation(){
                final /* synthetic */ Aggregation val$aggregation;
                {
                    this.val$aggregation = aggregation;
                }

                public AggregationType type() {
                    return AggregationType.valueOf((String)this.val$aggregation.getType().name().toUpperCase());
                }

                public String field() {
                    return this.val$aggregation.getField();
                }
            }).collect(Collectors.toList());
            query.setAggregations(aggregationList);
        }
        query.setTerms(terms);
        return this.analyticsService.execute(executionContext, query);
    }

    private Map<String, Set<String>> buildTerms(ExecutionContext executionContext, AnalyticsParam analyticsParam) throws FieldFilterEmptyException {
        Set ids;
        String fieldName;
        if (this.isAdmin()) {
            if (APPLICATION_FIELD.equalsIgnoreCase(analyticsParam.getField())) {
                fieldName = APPLICATION_FIELD;
                ApplicationQuery applicationQuery = new ApplicationQuery();
                applicationQuery.setStatus(ApplicationStatus.ACTIVE.name());
                applicationQuery.setExcludeFilters(List.of(ApplicationExcludeFilter.OWNER));
                ids = this.applicationService.searchIds(executionContext, applicationQuery, null);
            } else {
                fieldName = API_FIELD;
                ids = this.apiAuthorizationService.findIdsByEnvironment(executionContext.getEnvironmentId());
            }
        } else if (APPLICATION_FIELD.equalsIgnoreCase(analyticsParam.getField())) {
            fieldName = APPLICATION_FIELD;
            ids = this.applicationService.findIdsByUser(executionContext, this.getAuthenticatedUser()).stream().filter(appId -> this.permissionService.hasPermission(executionContext, RolePermission.APPLICATION_ANALYTICS, appId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toSet());
        } else {
            fieldName = API_FIELD;
            ids = this.apiAuthorizationService.findIdsByUser(executionContext, this.getAuthenticatedUser(), true).stream().filter(apiId -> this.permissionService.hasPermission(executionContext, RolePermission.API_ANALYTICS, apiId, new RolePermissionAction[]{RolePermissionAction.READ})).collect(Collectors.toSet());
        }
        if (ids.isEmpty()) {
            throw new FieldFilterEmptyException();
        }
        return Map.of(fieldName, ids);
    }

    private Analytics executeGroupBy(ExecutionContext executionContext, AnalyticsParam analyticsParam) {
        List<Range> ranges;
        Map<String, Set<String>> terms;
        switch (analyticsParam.getField()) {
            case "state": {
                return this.getTopHitsAnalytics(executionContext, api -> api.getState().name());
            }
            case "lifecycle_state": {
                return this.getTopHitsAnalytics(executionContext, api -> api.getLifecycleState().name());
            }
        }
        try {
            terms = this.buildTerms(executionContext, analyticsParam);
        }
        catch (FieldFilterEmptyException e) {
            return new TopHitsAnalytics();
        }
        GroupByQuery query = new GroupByQuery();
        query.setFrom(analyticsParam.getFrom());
        query.setTo(analyticsParam.getTo());
        query.setInterval(analyticsParam.getInterval());
        query.setQuery(analyticsParam.getQuery());
        query.setField(analyticsParam.getField());
        if (analyticsParam.getOrder() != null) {
            GroupByQuery.Order order = new GroupByQuery.Order();
            order.setField(analyticsParam.getOrder().getField());
            order.setType(analyticsParam.getOrder().getType());
            order.setOrder(analyticsParam.getOrder().isOrder());
            query.setOrder(order);
        }
        if ((ranges = analyticsParam.getRanges()) != null) {
            Map<Double, Double> rangeMap = ranges.stream().collect(Collectors.toMap(Range::getFrom, Range::getTo));
            query.setGroups(rangeMap);
        }
        query.setTerms(terms);
        return this.analyticsService.execute(executionContext, query);
    }

    @NotNull
    private TopHitsAnalytics getTopHitsAnalytics(ExecutionContext executionContext, Function<ApiEntity, String> groupingByFunction) {
        Set apis = this.isAdmin() ? new HashSet(this.apiService.search(executionContext, new ApiQuery())) : this.apiService.findByUser(executionContext, this.getAuthenticatedUser(), new ApiQuery(), true);
        Map<String, Long> collect = apis.stream().collect(Collectors.groupingBy(groupingByFunction, Collectors.counting()));
        TopHitsAnalytics topHitsAnalytics = new TopHitsAnalytics();
        topHitsAnalytics.setValues(collect);
        return topHitsAnalytics;
    }

    private class FieldFilterEmptyException
    extends Throwable {
        private FieldFilterEmptyException() {
        }
    }
}

