/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsAverageParam;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.HealthcheckField;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.HealthcheckType;
import io.gravitee.rest.api.management.rest.resource.param.healthcheck.LogsParam;
import io.gravitee.rest.api.model.analytics.Analytics;
import io.gravitee.rest.api.model.analytics.query.Aggregation;
import io.gravitee.rest.api.model.analytics.query.AggregationType;
import io.gravitee.rest.api.model.analytics.query.DateHistogramQuery;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.healthcheck.ApiMetrics;
import io.gravitee.rest.api.model.healthcheck.Log;
import io.gravitee.rest.api.model.healthcheck.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.HealthCheckService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@Tag(name="API Health")
public class ApiHealthResource
extends AbstractResource {
    @Inject
    private HealthCheckService healthCheckService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Health-check statistics for API")
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    @ApiResponse(responseCode="200", description="API health", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiMetrics.class))})
    public Response getApiHealth(@QueryParam(value="type") @DefaultValue(value="availability") HealthcheckType healthcheckType, @QueryParam(value="field") @DefaultValue(value="endpoint") HealthcheckField healthcheckField) {
        switch (healthcheckType) {
            case RESPONSE_TIME: {
                return Response.ok((Object)this.healthCheckService.getResponseTime(GraviteeContext.getExecutionContext(), this.api, healthcheckField.name())).build();
            }
        }
        return Response.ok((Object)this.healthCheckService.getAvailability(GraviteeContext.getExecutionContext(), this.api, healthcheckField.name())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Health-check average statistics for API")
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    @Path(value="/average")
    public Response getApiHealthAverage(@BeanParam AnalyticsAverageParam analyticsAverageParam) {
        return Response.ok((Object)this.executeDateHisto(this.api, analyticsAverageParam)).build();
    }

    private Analytics executeDateHisto(String api, final AnalyticsAverageParam analyticsAverageParam) {
        DateHistogramQuery query = new DateHistogramQuery();
        query.setFrom(analyticsAverageParam.getFrom());
        query.setTo(analyticsAverageParam.getTo());
        query.setInterval(analyticsAverageParam.getInterval());
        query.setRootField("api");
        query.setRootIdentifier(api);
        query.setAggregations(Collections.singletonList(new Aggregation(){

            public AggregationType type() {
                switch (analyticsAverageParam.getType()) {
                    case AVAILABILITY: {
                        return AggregationType.FIELD;
                    }
                }
                return AggregationType.AVG;
            }

            public String field() {
                switch (analyticsAverageParam.getType()) {
                    case AVAILABILITY: {
                        return "available";
                    }
                }
                return "response-time";
            }
        }));
        return this.healthCheckService.query(query);
    }

    @GET
    @Path(value="logs")
    @Produces(value={"application/json"})
    @Operation(summary="Health-check logs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API logs", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchLogResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    public SearchLogResponse getApiHealthCheckLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        return this.healthCheckService.findByApi(GraviteeContext.getExecutionContext(), this.api, logQuery, param.isTransition());
    }

    @GET
    @Path(value="logs/{log}")
    @Produces(value={"application/json"})
    @Operation(summary="Health-check log")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Single health-check log", content={@Content(mediaType="application/json", schema=@Schema(implementation=Log.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_HEALTH, acls={RolePermissionAction.READ})})
    public Log getApiHealthCheckLog(@PathParam(value="log") String logId) {
        return this.healthCheckService.findLog(this.api, logId);
    }
}

