/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.idp.ldap.authentication;

import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.idp.ldap.utils.LdapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class UserDetailsContextPropertiesMapper
implements UserDetailsContextMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsContextPropertiesMapper.class);
    private static final String LDAP_ATTRIBUTE_UID = "uid";
    private static final String LDAP_ATTRIBUTE_FIRSTNAME = "givenName";
    private static final String LDAP_ATTRIBUTE_LASTNAME = "sn";
    private static final String LDAP_ATTRIBUTE_MAIL = "mail";
    private Environment environment;
    private String identifierAttribute;

    public void afterPropertiesSet() throws Exception {
        String searchFilter = this.environment.getProperty("authentication.user.filter");
        if (searchFilter != null) {
            this.identifierAttribute = LdapUtils.extractAttribute(searchFilter);
        }
        if (this.identifierAttribute == null) {
            this.identifierAttribute = LDAP_ATTRIBUTE_UID;
        }
    }

    /*
     * WARNING - void declaration
     */
    public org.springframework.security.core.userdetails.UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        void var6_10;
        ArrayList mappedAuthorities = new ArrayList();
        try {
            for (GrantedAuthority grantedAuthority : authorities) {
                String mappedAuthority = this.environment.getProperty("authentication.group.role.mapper." + grantedAuthority.getAuthority());
                if (mappedAuthority == null || mappedAuthority.isEmpty()) continue;
                Stream.of(mappedAuthority.split(",")).forEach(a -> mappedAuthorities.add(new SimpleGrantedAuthority(a)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mapped authorities", (Throwable)e);
        }
        UserDetails userDetails = new UserDetails(ctx.getStringAttribute(this.identifierAttribute), "", mappedAuthorities);
        String string = this.environment.getProperty("authentication.user.photo-attribute");
        if (string == null) {
            String string2 = "jpegPhoto";
        }
        userDetails.setFirstname(ctx.getStringAttribute(LDAP_ATTRIBUTE_FIRSTNAME));
        userDetails.setLastname(ctx.getStringAttribute(LDAP_ATTRIBUTE_LASTNAME));
        userDetails.setEmail(ctx.getStringAttribute(LDAP_ATTRIBUTE_MAIL));
        userDetails.setSource("ldap");
        userDetails.setSourceId(ctx.getNameInNamespace());
        userDetails.setPicture((byte[])ctx.getObjectAttribute((String)var6_10));
        return userDetails;
    }

    public void mapUserToContext(org.springframework.security.core.userdetails.UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("UserDetailsContextPropertiesMapper only supports reading from a context. Pleaseuse a subclass if mapUserToContext() is required.");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

