/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.idp.api.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.idp.api.authentication.UserDetailRole;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class UserDetails
extends User
implements org.springframework.security.core.userdetails.UserDetails {
    private String id;
    private String email;
    private String firstname;
    private String lastname;
    private String source;
    private String sourceId;
    private boolean isPrimaryOwner;
    private List<UserDetailRole> roles;
    private Map<String, Set<String>> groupsByEnvironment;
    private String username;
    private byte[] picture;
    private boolean firstLogin;
    private boolean displayNewsletterSubscription;
    private Map<String, Object> customFields;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="last_connection_at")
    private Date lastConnectionAt;

    public UserDetails(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
        this.username = username;
    }

    public UserDetails(String username, String password, String email, Collection<? extends GrantedAuthority> authorities) {
        this(username, password, authorities);
        this.email = email;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public String getUsername() {
        return this.username;
    }

    @JsonIgnore
    public String getPassword() {
        return super.getPassword();
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return super.isAccountNonExpired();
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return super.isAccountNonLocked();
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return super.isCredentialsNonExpired();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getDisplayName() {
        String displayName = this.firstname != null && !this.firstname.isEmpty() || this.lastname != null && !this.lastname.isEmpty() ? (this.firstname != null && !this.firstname.isEmpty() ? this.firstname + (this.lastname != null && !this.lastname.isEmpty() ? ' ' + this.lastname : "") : this.lastname) : (this.email != null && !this.email.isEmpty() && !"memory".equals(this.source) ? this.email : this.sourceId);
        return displayName;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public List<UserDetailRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<UserDetailRole> roles) {
        this.roles = roles;
    }

    public Map<String, Set<String>> getGroupsByEnvironment() {
        return this.groupsByEnvironment;
    }

    public void setGroupsByEnvironment(Map<String, Set<String>> groupsByEnvironment) {
        this.groupsByEnvironment = groupsByEnvironment;
    }

    public boolean isFirstLogin() {
        return this.firstLogin;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.firstLogin = firstLogin;
    }

    public void setDisplayNewsletterSubscription(boolean displayNewsletterSubscription) {
        this.displayNewsletterSubscription = displayNewsletterSubscription;
    }

    public boolean isDisplayNewsletterSubscription() {
        return this.displayNewsletterSubscription;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getLastConnectionAt() {
        return this.lastConnectionAt;
    }

    public void setLastConnectionAt(Date lastConnectionAt) {
        this.lastConnectionAt = lastConnectionAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String toString() {
        return super.toString() + ", email='" + this.email + '\'' + ", firstname='" + this.firstname + '\'' + ", lastname='" + this.lastname + '\'' + ", source='" + this.lastname + '\'' + ", external_reference='" + this.lastname + '\'' + "}";
    }

    public byte[] getPicture() {
        return this.picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
    }

    public void setPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public boolean isPrimaryOwner() {
        return this.isPrimaryOwner;
    }

    public void setPrimaryOwner(boolean primaryOwner) {
        this.isPrimaryOwner = primaryOwner;
    }
}

