/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.soap;

import io.gravitee.rest.api.spec.converter.wsdl.binding.SoapVersion;
import io.gravitee.rest.api.spec.converter.wsdl.utils.SampleXmlUtil;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;

public abstract class AbstractSoapBuilder {
    private SchemaTypeSystem schemaTypeSystem;
    private Map<String, String> namespaceMappings;
    protected SoapVersion version;
    protected BindingOperation bindingOperation;
    protected XmlCursor xmlCursor;

    public AbstractSoapBuilder withVersion(SoapVersion version) {
        this.version = version;
        return this;
    }

    public AbstractSoapBuilder withBindingOperation(BindingOperation bindingOperation) {
        this.bindingOperation = bindingOperation;
        return this;
    }

    public AbstractSoapBuilder withCursor(XmlCursor cursor) {
        this.xmlCursor = cursor;
        return this;
    }

    public AbstractSoapBuilder withShemaTypeSystem(SchemaTypeSystem shemaTypeSystem) {
        this.schemaTypeSystem = shemaTypeSystem;
        return this;
    }

    public AbstractSoapBuilder withNamespaceMappings(Map<String, String> namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
        return this;
    }

    public abstract XmlCursor build();

    protected void generateXml(Part part, XmlCursor cursor, boolean encoded) {
        if (part.getElementName() != null) {
            QName rootName = new QName(part.getElementName().getNamespaceURI(), part.getElementName().getLocalPart());
            SchemaType[] globalElems = this.schemaTypeSystem.documentTypes();
            SchemaType elem = null;
            for (int j = 0; j < globalElems.length; ++j) {
                if (!rootName.equals(globalElems[j].getDocumentElementName())) continue;
                elem = globalElems[j];
                break;
            }
            if (encoded) {
                cursor.insertAttributeWithValue(SampleXmlUtil.XSI_TYPE, this.buildPrefixedName(elem));
            }
            new SampleXmlUtil(encoded).createSampleForType(elem, cursor);
        } else {
            SchemaType type = this.schemaTypeSystem.findType(part.getTypeName());
            if (type == null) {
                type = BuiltinSchemaTypeSystem.get().findType(part.getTypeName());
            }
            if (type != null) {
                if (encoded) {
                    cursor.insertAttributeWithValue(SampleXmlUtil.XSI_TYPE, this.buildPrefixedName(type));
                }
                new SampleXmlUtil(encoded).createSampleForType(type, cursor);
            }
        }
    }

    protected String buildPrefixedName(SchemaType type) {
        String prefix = this.namespaceMappings.get(type.getName().getNamespaceURI());
        return prefix + ":" + type.getName().getLocalPart();
    }
}

