/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.spec.converter.OpenAPIConverter;
import io.gravitee.rest.api.spec.converter.wsdl.SoapMessageBuilder;
import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.exception.WsdlDescriptorException;
import io.gravitee.rest.api.spec.converter.wsdl.reader.GraviteeWSDLReaderImpl;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLToOpenAPIConverter
implements OpenAPIConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WSDLToOpenAPIConverter.class);
    public static final String SOAP_EXTENSION_ENVELOPE = "x-graviteeio-soap-envelope";
    public static final String SOAP_EXTENSION_ACTION = "x-graviteeio-soap-action";
    private OpenAPI openAPI;
    private Definition wsdlDefinition;
    private SoapMessageBuilder soapBuilder;
    private Set<String> serverCache = new HashSet<String>();

    @Override
    public OpenAPI toOpenAPI(String content) {
        return this.toOpenAPI(new ByteArrayInputStream(content.getBytes()));
    }

    @Override
    public OpenAPI toOpenAPI(InputStream stream) {
        Objects.requireNonNull(stream, "WSDL input source is required");
        this.wsdlDefinition = this.loadWSDL(stream);
        this.soapBuilder = new SoapMessageBuilder(this.wsdlDefinition.getNamespaces());
        this.openAPI = new OpenAPI();
        this.buildInfo();
        this.createSchemaObjects(this.wsdlDefinition);
        this.processServices();
        return this.openAPI;
    }

    private Definition loadWSDL(InputStream stream) {
        try {
            GraviteeWSDLReaderImpl reader = new GraviteeWSDLReaderImpl();
            reader.setFeature("javax.wsdl.importDocuments", true);
            return reader.readWSDL(null, new InputSource(stream));
        }
        catch (WSDLException e) {
            log.error("Unable to read WSDL from input stream.", (Throwable)e);
            throw new WsdlDescriptorException("Unable to read WSDL");
        }
    }

    private void buildInfo() {
        Info info = new Info();
        info.version("1.0.0");
        if (this.wsdlDefinition.getQName() != null) {
            info.setTitle(this.wsdlDefinition.getQName().getLocalPart());
        } else {
            info.setTitle(this.wsdlDefinition.getTargetNamespace());
        }
        Element documentation = this.wsdlDefinition.getDocumentationElement();
        if (documentation != null) {
            info.setDescription(documentation.getTextContent());
        }
        this.openAPI.setInfo(info);
    }

    private void createSchemaObjects(Definition definition) {
        Types types = definition.getTypes();
        if (types != null) {
            types.getExtensibilityElements().forEach(o -> this.soapBuilder.addSchema((javax.wsdl.extensions.schema.Schema)o));
        }
        if (definition.getImports() != null && !definition.getImports().isEmpty()) {
            definition.getImports().values().stream().flatMap(Collection::stream).map(Import::getDefinition).filter(Objects::nonNull).forEach(this::createSchemaObjects);
        }
    }

    private void processServices() {
        Map services = this.wsdlDefinition.getServices();
        services.values().stream().forEach(this::processPorts);
    }

    private void processPorts(Service serviceDefinition) {
        boolean singlePort;
        Map ports = serviceDefinition.getPorts();
        Iterator portIterator = ports.entrySet().iterator();
        boolean bl = singlePort = ports.size() == 1;
        while (portIterator.hasNext()) {
            Map.Entry entry = portIterator.next();
            String portName = (String)entry.getKey();
            Port portDefinition = (Port)entry.getValue();
            this.createServer(this.openAPI, portDefinition);
            Binding binding = this.wsdlDefinition.getBinding(portDefinition.getBinding().getQName());
            for (int i = 0; i < binding.getBindingOperations().size(); ++i) {
                Message msg;
                Input input;
                BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperations().get(i);
                javax.wsdl.Operation operation = bindingOperation.getOperation();
                String operationName = operation.getName();
                PathItem pathItem = new PathItem();
                Operation openApiOperation = new Operation();
                openApiOperation.operationId(String.join((CharSequence)"_", binding.getQName().getLocalPart(), operationName));
                if (operation.getDocumentationElement() != null) {
                    openApiOperation.description(operation.getDocumentationElement().getTextContent());
                }
                if ((input = operation.getInput()) != null) {
                    WSDLUtils.extractSOAPAction(bindingOperation).ifPresent(action -> openApiOperation.addExtension(SOAP_EXTENSION_ACTION, action));
                    this.soapBuilder.generateSoapEnvelop(this.wsdlDefinition, binding, bindingOperation).ifPresent(envelope -> openApiOperation.addExtension(SOAP_EXTENSION_ENVELOPE, envelope));
                }
                Content nodefContent = new Content();
                MediaType item = new MediaType();
                Schema schema = new Schema();
                schema.setType("object");
                item.setSchema(schema);
                nodefContent.addMediaType("application/json", item);
                Output output = operation.getOutput();
                ApiResponse successResp = new ApiResponse();
                successResp.content(nodefContent);
                successResp.setDescription("");
                if (output != null && (msg = output.getMessage()) != null && msg.getDocumentationElement() != null) {
                    successResp.description(operation.getDocumentationElement().getTextContent());
                }
                ApiResponse errorResp = new ApiResponse();
                errorResp.description("Error throws by the Backend Service");
                errorResp.content(nodefContent);
                ApiResponses responses = new ApiResponses();
                responses.addApiResponse(Integer.toString(200), successResp);
                responses.addApiResponse(Integer.toString(500), errorResp);
                openApiOperation.setResponses(responses);
                switch (this.detectHttpMethod(operationName)) {
                    case GET: {
                        pathItem.get(openApiOperation);
                        break;
                    }
                    case DELETE: {
                        pathItem.delete(openApiOperation);
                        break;
                    }
                    case PUT: {
                        pathItem.put(openApiOperation);
                        break;
                    }
                    default: {
                        pathItem.post(openApiOperation);
                    }
                }
                if (singlePort) {
                    this.openAPI.path(String.join((CharSequence)"/", "", serviceDefinition.getQName().getLocalPart(), operationName), pathItem);
                    continue;
                }
                this.openAPI.path(String.join((CharSequence)"/", "", serviceDefinition.getQName().getLocalPart(), portName, operationName), pathItem);
            }
        }
    }

    private HttpMethod detectHttpMethod(String operationName) {
        String name = operationName.toLowerCase();
        if (name.startsWith("get") || name.startsWith("find") || name.startsWith("search")) {
            return HttpMethod.GET;
        }
        if (name.startsWith("delete") || name.startsWith("remove")) {
            return HttpMethod.DELETE;
        }
        if (name.startsWith("update")) {
            return HttpMethod.PUT;
        }
        return HttpMethod.POST;
    }

    private void createServer(OpenAPI openAPI, Port port) {
        String address = WSDLUtils.extractSOAPAddress(port);
        if (!this.serverCache.contains(address)) {
            Server server = new Server();
            server.setUrl(address);
            openAPI.addServersItem(server);
            this.serverCache.add(address);
        }
    }
}

