/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.soap;

import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.binding.BobyParts;
import io.gravitee.rest.api.spec.converter.wsdl.soap.AbstractSoapBuilder;
import io.gravitee.rest.api.spec.converter.wsdl.utils.SampleXmlUtil;
import java.util.Objects;
import javax.wsdl.Input;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;

public class SoapBodyBuilder
extends AbstractSoapBuilder {
    @Override
    public XmlCursor build() {
        BobyParts bodyParts = null;
        if (this.version.hasBodyElement(this.bindingOperation.getBindingInput().getExtensibilityElements())) {
            bodyParts = this.version.extractBodyParts(this.bindingOperation.getBindingInput().getExtensibilityElements());
        }
        Input input = this.bindingOperation.getOperation().getInput();
        this.xmlCursor.beginElement(this.version.getBodyQName());
        if (bodyParts != null) {
            if (bodyParts.useEncoded()) {
                this.xmlCursor.insertAttributeWithValue(SampleXmlUtil.XSI_TYPE, WSDLUtils.formatQName(this.version.getBodyQName()));
            }
            if (!this.version.isRpcStyle()) {
                this.xmlCursor.toFirstChild();
                if (Objects.isNull(bodyParts.getPartNames()) || bodyParts.getPartNames().isEmpty()) {
                    for (Part part : input.getMessage().getParts().values()) {
                        this.generateXml(part, this.xmlCursor, bodyParts.useEncoded());
                    }
                } else {
                    for (String partName : bodyParts.getPartNames()) {
                        this.generateXml((Part)input.getMessage().getParts().get(partName), this.xmlCursor, bodyParts.useEncoded());
                    }
                }
                this.xmlCursor.toParent();
                this.xmlCursor.toParent();
            } else if (this.version.isRpcStyle()) {
                String ns = this.version.getRpcNamespace(this.bindingOperation);
                this.xmlCursor.toFirstChild();
                this.xmlCursor.beginElement(new QName(ns, this.bindingOperation.getName()));
                if (bodyParts.useEncoded()) {
                    this.xmlCursor.insertAttributeWithValue(this.version.getEncodingStyleQName(), "http://schemas.xmlsoap.org/soap/encoding/");
                }
                if (Objects.isNull(bodyParts.getPartNames()) || bodyParts.getPartNames().isEmpty()) {
                    for (Part part : input.getMessage().getParts().values()) {
                        this.generateRpcPart(this.xmlCursor, part, bodyParts.useEncoded());
                    }
                } else {
                    for (String partName : bodyParts.getPartNames()) {
                        Part part = (Part)input.getMessage().getParts().get(partName);
                        this.generateRpcPart(this.xmlCursor, part, bodyParts.useEncoded());
                    }
                }
            }
        } else {
            this.xmlCursor.toParent();
        }
        return this.xmlCursor;
    }

    private void generateRpcPart(XmlCursor envelopeCursor, Part part, boolean encoded) {
        envelopeCursor.toLastChild();
        envelopeCursor.insertElement(part.getName());
        envelopeCursor.toPrevToken();
        this.generateXml(part, envelopeCursor, encoded);
        envelopeCursor.toParent();
    }
}

